/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.io.sif.level3.ParticipatesRule;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.TemplateReactionRegulation;

public class ExpressionRule
extends InteractionRuleL3Adaptor {
    private final Log log = LogFactory.getLog(ParticipatesRule.class);
    private static final List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.UPREGULATE_EXPRESSION, BinaryInteractionType.DOWNREGULATE_EXPRESSION);

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 interactionSet, PhysicalEntity pe, Model model) {
        for (Control ctrl : pe.getControllerOf()) {
            BinaryInteractionType type;
            BinaryInteractionType binaryInteractionType = type = ctrl.getControlType() != null && ctrl.getControlType().toString().startsWith("I") ? BinaryInteractionType.DOWNREGULATE_EXPRESSION : BinaryInteractionType.UPREGULATE_EXPRESSION;
            if (!(ctrl instanceof TemplateReactionRegulation)) continue;
            for (Process process2 : ctrl.getControlled()) {
                if (!(process2 instanceof TemplateReaction)) continue;
                TemplateReaction tr = (TemplateReaction)process2;
                for (PhysicalEntity prod : tr.getProduct()) {
                    this.createAndAdd(interactionSet.getGroupMap().getEntityReferenceOrGroup(pe), interactionSet.getGroupMap().getEntityReferenceOrGroup(prod), interactionSet, type, ctrl, tr);
                }
            }
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

