/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level2;

import org.biopax.paxtools.impl.level2.BioPAXLevel2ElementImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.kPrime;

class kPrimeImpl
extends BioPAXLevel2ElementImpl
implements kPrime {
    private float K_PRIME = BioPAXElement.UNKNOWN_FLOAT.floatValue();
    private float TEMPERATURE = BioPAXElement.UNKNOWN_FLOAT.floatValue();
    private float IONIC_STRENGTH = BioPAXElement.UNKNOWN_FLOAT.floatValue();
    private float PH = BioPAXElement.UNKNOWN_FLOAT.floatValue();
    private float PMG = BioPAXElement.UNKNOWN_FLOAT.floatValue();

    kPrimeImpl() {
    }

    @Override
    public int equivalenceCode() {
        int result = 29.0f + this.K_PRIME != 0.0f ? Float.floatToIntBits(this.K_PRIME) : 0;
        result = (float)(29 * result) + this.TEMPERATURE != 0.0f ? Float.floatToIntBits(this.TEMPERATURE) : 0;
        result = (float)(29 * result) + this.IONIC_STRENGTH != 0.0f ? Float.floatToIntBits(this.IONIC_STRENGTH) : 0;
        result = (float)(29 * result) + this.PH != 0.0f ? Float.floatToIntBits(this.PH) : 0;
        result = (float)(29 * result) + this.PMG != 0.0f ? Float.floatToIntBits(this.PMG) : 0;
        return result;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        kPrime aKPrime = (kPrime)element;
        return Float.compare(aKPrime.getIONIC_STRENGTH(), this.IONIC_STRENGTH) == 0 && Float.compare(aKPrime.getK_PRIME(), this.K_PRIME) == 0 && Float.compare(aKPrime.getPH(), this.PH) == 0 && Float.compare(aKPrime.getPMG(), this.PMG) == 0 && Float.compare(aKPrime.getTEMPERATURE(), this.TEMPERATURE) == 0;
    }

    @Override
    public Class<? extends BioPAXElement> getModelInterface() {
        return kPrime.class;
    }

    @Override
    public float getK_PRIME() {
        return this.K_PRIME;
    }

    @Override
    public void setK_PRIME(float K_PRIME) {
        this.K_PRIME = K_PRIME;
    }

    @Override
    public float getTEMPERATURE() {
        return this.TEMPERATURE;
    }

    @Override
    public void setTEMPERATURE(float TEMPERATURE) {
        this.TEMPERATURE = TEMPERATURE;
    }

    @Override
    public float getIONIC_STRENGTH() {
        return this.IONIC_STRENGTH;
    }

    @Override
    public void setIONIC_STRENGTH(float IONIC_STRENGTH) {
        this.IONIC_STRENGTH = IONIC_STRENGTH;
    }

    @Override
    public float getPH() {
        return this.PH;
    }

    @Override
    public void setPH(float PH) {
        this.PH = PH;
    }

    @Override
    public float getPMG() {
        return this.PMG;
    }

    @Override
    public void setPMG(float PMG) {
        this.PMG = PMG;
    }
}

