/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVars;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.Collection;
import java.util.Set;

public abstract class ExprNode
implements Expr {
    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        try {
            NodeValue v = this.eval(binding, execCxt);
            boolean b = XSDFuncOp.booleanEffectiveValue(v);
            return b;
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    public boolean isExpr() {
        return true;
    }

    public final Expr getExpr() {
        return this;
    }

    public abstract NodeValue eval(Binding var1, FunctionEnv var2);

    public Set getVarsMentioned() {
        return ExprVars.getVarsMentioned(this);
    }

    public void varsMentioned(Collection acc) {
        ExprVars.varsMentioned(acc, this);
    }

    public Set getVarNamesMentioned() {
        return ExprVars.getVarNamesMentioned(this);
    }

    public void varNamesMentioned(Collection acc) {
        ExprVars.varNamesMentioned(acc, this);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public final Expr copySubstitute(Binding binding) {
        return this.copySubstitute(binding, false);
    }

    public final Expr deepCopy() {
        return this.copySubstitute(null, false);
    }

    public abstract Expr copySubstitute(Binding var1, boolean var2);

    public boolean isVariable() {
        return false;
    }

    public String getVarName() {
        return null;
    }

    public final ExprVar getNodeVar() {
        return this.getExprVar();
    }

    public ExprVar getExprVar() {
        return null;
    }

    public Var asVar() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public NodeValue getConstant() {
        return null;
    }

    public boolean isFunction() {
        return false;
    }

    public ExprFunction getFunction() {
        return null;
    }

    public String toString() {
        return ExprUtils.fmtSPARQL(this);
    }
}

