/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.wrapperL3.ControlWrapper;
import org.biopax.paxtools.query.wrapperL3.EdgeL3;
import org.biopax.paxtools.query.wrapperL3.EventWrapper;
import org.biopax.paxtools.query.wrapperL3.GraphL3;

public class TemplateReactionWrapper
extends EventWrapper {
    private TemplateReaction tempReac;

    protected TemplateReactionWrapper(TemplateReaction tempReac, GraphL3 graph) {
        super(graph);
        this.tempReac = tempReac;
    }

    @Override
    public void initUpstream() {
        NucleicAcid nuc = this.tempReac.getTemplate();
        if (nuc != null) {
            this.addToUpstream(nuc, this.getGraph());
        }
        for (Control cont : this.tempReac.getControlledOf()) {
            this.addToUpstream(cont, this.graph);
        }
    }

    @Override
    public void initDownstream() {
        for (PhysicalEntity pe : this.tempReac.getProduct()) {
            this.addToDownstream(pe, this.getGraph());
        }
    }

    @Override
    public boolean isTranscription() {
        return true;
    }

    @Override
    protected void addToDownstream(PhysicalEntity pe, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(pe);
        if (node != null) {
            EdgeL3 edge = new EdgeL3(this, node, graph);
            edge.setTranscription(true);
            node.getUpstreamNoInit().add(edge);
            this.getDownstreamNoInit().add(edge);
        }
    }

    @Override
    protected void addToUpstream(BioPAXElement ele, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(ele);
        if (node == null) {
            return;
        }
        EdgeL3 edge = new EdgeL3(node, this, graph);
        if (this.isTranscription() && node instanceof ControlWrapper) {
            ((ControlWrapper)node).setTranscription(true);
        }
        node.getDownstreamNoInit().add(edge);
        this.getUpstreamNoInit().add(edge);
    }

    @Override
    public String getKey() {
        return this.tempReac.getRDFId();
    }

    public TemplateReaction getTempReac() {
        return this.tempReac;
    }
}

