/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.algorithm.CycleBreaker;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.algorithm.Prune;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class PathsFromToQuery {
    private Set<Node> sourceSet;
    private Set<Node> targetSet;
    private LimitType limitType;
    private int stopDistance;
    private boolean strict;
    private static final int LIMIT_FOR_SP_SEARCH = 25;

    public PathsFromToQuery(Set<Node> sourceSet, Set<Node> targetSet, LimitType limitType, int stopDistance, boolean strict) {
        assert (limitType != null) : "limitType should be specified";
        this.sourceSet = sourceSet;
        this.targetSet = targetSet;
        this.limitType = limitType;
        this.stopDistance = stopDistance;
        this.strict = strict;
    }

    public Set<GraphObject> run() {
        HashMap<GraphObject, Integer> candidate = new HashMap<GraphObject, Integer>();
        HashSet<GraphObject> result = new HashSet<GraphObject>();
        BFS bfsFwd = null;
        BFS bfsRev = null;
        if (this.limitType == LimitType.NORMAL && !this.strict) {
            bfsFwd = new BFS(this.sourceSet, null, Direction.DOWNSTREAM, this.stopDistance);
            bfsRev = new BFS(this.targetSet, null, Direction.UPSTREAM, this.stopDistance);
        } else if (this.limitType == LimitType.NORMAL && this.strict) {
            bfsFwd = new BFS(this.sourceSet, this.targetSet, Direction.DOWNSTREAM, this.stopDistance);
            bfsRev = new BFS(this.targetSet, this.sourceSet, Direction.UPSTREAM, this.stopDistance);
        } else if (this.limitType == LimitType.SHORTEST_PLUS_K && !this.strict) {
            bfsFwd = new BFS(this.sourceSet, null, Direction.DOWNSTREAM, 25);
            bfsRev = new BFS(this.targetSet, null, Direction.UPSTREAM, 25);
        } else if (this.limitType == LimitType.SHORTEST_PLUS_K && this.strict) {
            bfsFwd = new BFS(this.sourceSet, this.targetSet, Direction.DOWNSTREAM, 25);
            bfsRev = new BFS(this.targetSet, this.sourceSet, Direction.UPSTREAM, 25);
        }
        candidate.putAll(bfsFwd.run());
        candidate.putAll(bfsRev.run());
        int limit = this.stopDistance;
        if (this.limitType == LimitType.NORMAL) {
            for (GraphObject go : candidate.keySet()) {
                if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > limit) continue;
                result.add(go);
            }
        } else {
            int shortestPath = Integer.MAX_VALUE;
            for (GraphObject go : candidate.keySet()) {
                if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > shortestPath) continue;
                shortestPath = bfsFwd.getLabel(go) + bfsRev.getLabel(go);
            }
            limit = shortestPath + this.stopDistance;
            if (shortestPath < 0x3FFFFFFF) {
                for (GraphObject go : candidate.keySet()) {
                    if (bfsFwd.getLabel(go) + bfsRev.getLabel(go) > limit) continue;
                    result.add(go);
                }
            }
        }
        HashSet<Node> ST = new HashSet<Node>(this.sourceSet);
        ST.addAll(this.targetSet);
        CycleBreaker breaker = new CycleBreaker(result, ST, limit);
        breaker.breakCycles();
        Prune prune = new Prune(result, ST);
        prune.run();
        return result;
    }
}

