/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.algorithm.CycleBreaker;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.algorithm.Prune;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class PathsBetweenQuery {
    private Collection<Set<Node>> sourceSet;
    private int limit;

    public PathsBetweenQuery(Collection<Set<Node>> sourceSet, int limit) {
        this.sourceSet = sourceSet;
        this.limit = limit;
    }

    public Set<GraphObject> run() {
        HashMap<GraphObject, Map<Set<Node>, Integer>> fwdObj = new HashMap<GraphObject, Map<Set<Node>, Integer>>();
        HashMap<GraphObject, Map<Set<Node>, Integer>> revObj = new HashMap<GraphObject, Map<Set<Node>, Integer>>();
        HashSet<GraphObject> result = new HashSet<GraphObject>();
        for (Set<Node> set : this.sourceSet) {
            BFS bfsFwd = new BFS(set, null, Direction.DOWNSTREAM, this.limit);
            BFS bfsRev = new BFS(set, null, Direction.UPSTREAM, this.limit);
            this.recordLabels(fwdObj, set, bfsFwd.run());
            this.recordLabels(revObj, set, bfsRev.run());
        }
        for (GraphObject go : fwdObj.keySet()) {
            if (!revObj.containsKey(go) || !this.onTheResultPath((Map)fwdObj.get(go), (Map)revObj.get(go))) continue;
            result.add(go);
        }
        HashSet<Node> sources = new HashSet<Node>();
        for (Set<Node> set : this.sourceSet) {
            sources.addAll(set);
        }
        CycleBreaker breaker = new CycleBreaker(result, sources, this.limit);
        breaker.breakCycles();
        Prune prune = new Prune(result, sources);
        prune.run();
        return result;
    }

    private void recordLabels(Map<GraphObject, Map<Set<Node>, Integer>> labels, Set<Node> set, Map<GraphObject, Integer> bfsResult) {
        for (GraphObject go : bfsResult.keySet()) {
            if (!labels.containsKey(go)) {
                labels.put(go, new HashMap());
            }
            labels.get(go).put(set, bfsResult.get(go));
        }
    }

    private boolean onTheResultPath(Map<Set<Node>, Integer> fwdMap, Map<Set<Node>, Integer> revMap) {
        for (Set<Node> set1 : fwdMap.keySet()) {
            for (Set<Node> set2 : revMap.keySet()) {
                int dist;
                if (set1 == set2 || (dist = fwdMap.get(set1) + revMap.get(set2)) > this.limit) continue;
                return true;
            }
        }
        return false;
    }
}

