/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.Type;
import org.biopax.paxtools.pattern.miner.MinerAdapter;

public class DirectedRelationMiner
extends MinerAdapter {
    public DirectedRelationMiner() {
        super("directed-relations", "Finds relations between proteins where the first one is controlling an interaction where the second protein is participant.");
    }

    @Override
    public Pattern constructPattern() {
        Pattern p = new Pattern(ProteinReference.class, "controller PR");
        p.add(ConBox.isHuman(), "controller PR");
        p.add(ConBox.erToPE(), "controller PR", "controller simple PE");
        p.add(ConBox.linkToComplex(), "controller simple PE", "controller PE");
        p.add(ConBox.peToControl(), "controller PE", "Control");
        p.add(ConBox.controlToInter(), "Control", "Interaction");
        p.add((Constraint)new NOT(ConBox.participantER()), "Interaction", "controller PR");
        p.add(ConBox.participant(), "Interaction", "affected PE");
        p.add(ConBox.linkToSimple(), "affected PE", "affected simple PE");
        p.add((Constraint)new Type(Protein.class), "affected simple PE");
        p.add(ConBox.peToER(), "affected simple PE", "affected PR");
        return p;
    }

    @Override
    public void writeResult(Map<BioPAXElement, List<Match>> matches2, OutputStream out) throws IOException {
        this.writeResultAsSIF(matches2, out, true, this.getSourceLabel(), this.getTargetLabel());
    }

    @Override
    public String getHeader() {
        return "Upstream\tDownstream";
    }

    public String getSourceLabel() {
        return "controller PR";
    }

    public String getTargetLabel() {
        return "affected PR";
    }

    @Override
    public String[] getMediatorLabels() {
        return new String[]{"Control", "Interaction"};
    }
}

