/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.TreeSet;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyDumperFSS {
    protected final PrintWriter m_out;

    public HierarchyDumperFSS(PrintWriter printWriter) {
        this.m_out = printWriter;
    }

    public void printAtomicConceptHierarchy(Hierarchy<AtomicConcept> hierarchy) {
        for (HierarchyNode<AtomicConcept> hierarchyNode : hierarchy.getAllNodesSet()) {
            TreeSet<AtomicConcept> treeSet = new TreeSet<AtomicConcept>(AtomicConceptComparator.INSTANCE);
            treeSet.addAll(hierarchyNode.getEquivalentElements());
            AtomicConcept atomicConcept = (AtomicConcept)treeSet.first();
            if (treeSet.size() > 1) {
                boolean bl = true;
                for (AtomicConcept atomicConcept2 : treeSet) {
                    if (bl) {
                        this.m_out.print("EquivalentClasses( <");
                        this.m_out.print(atomicConcept.getIRI());
                        this.m_out.print(">");
                        bl = false;
                        continue;
                    }
                    this.m_out.print(" <");
                    this.m_out.print(atomicConcept2.getIRI());
                    this.m_out.print(">");
                }
                this.m_out.print(" )");
                this.m_out.println();
            }
            if (atomicConcept.equals(AtomicConcept.THING)) continue;
            for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getChildNodes()) {
                AtomicConcept atomicConcept2;
                atomicConcept2 = (AtomicConcept)hierarchyNode2.getRepresentative();
                if (atomicConcept2.equals(AtomicConcept.NOTHING)) continue;
                this.m_out.print("SubClassOf( <");
                this.m_out.print(atomicConcept2.getIRI());
                this.m_out.print("> <");
                this.m_out.print(atomicConcept.getIRI());
                this.m_out.print("> )");
                this.m_out.println();
            }
        }
        this.m_out.println();
    }

    public void printObjectPropertyHierarchy(Hierarchy<Role> hierarchy) {
        for (HierarchyNode<Role> hierarchyNode : hierarchy.getAllNodesSet()) {
            TreeSet<Role> treeSet = new TreeSet<Role>(ObjectRoleComparator.INSTANCE);
            treeSet.addAll(hierarchyNode.getEquivalentElements());
            Role role = (Role)treeSet.first();
            if (treeSet.size() > 1) {
                boolean bl = true;
                for (Role role2 : treeSet) {
                    if (bl) {
                        this.m_out.print("EquivalentObjectProperties( ");
                        this.print(role);
                        bl = false;
                        continue;
                    }
                    this.m_out.print(" ");
                    this.print(role2);
                }
                this.m_out.print(" )");
                this.m_out.println();
            }
            if (role.equals(AtomicRole.TOP_OBJECT_ROLE)) continue;
            for (HierarchyNode<Role> hierarchyNode2 : hierarchyNode.getChildNodes()) {
                Role role2;
                role2 = (Role)hierarchyNode2.getRepresentative();
                if (role2.equals(AtomicRole.BOTTOM_OBJECT_ROLE)) continue;
                this.m_out.print("SubObjectPropertyOf( ");
                this.print(role2);
                this.m_out.print(" ");
                this.print(role);
                this.m_out.print(" )");
                this.m_out.println();
            }
        }
        this.m_out.println();
    }

    public void printDataPropertyHierarchy(Hierarchy<AtomicRole> hierarchy) {
        for (HierarchyNode<AtomicRole> hierarchyNode : hierarchy.getAllNodesSet()) {
            TreeSet<AtomicRole> treeSet = new TreeSet<AtomicRole>(DataRoleComparator.INSTANCE);
            treeSet.addAll(hierarchyNode.getEquivalentElements());
            AtomicRole atomicRole = (AtomicRole)treeSet.first();
            if (treeSet.size() > 1) {
                boolean bl = true;
                for (AtomicRole atomicRole2 : treeSet) {
                    if (bl) {
                        this.m_out.print("EquivalentDataProperties( <");
                        this.m_out.print(atomicRole.getIRI());
                        this.m_out.print(">");
                        bl = false;
                        continue;
                    }
                    this.m_out.print(" >");
                    this.m_out.print(atomicRole2.getIRI());
                    this.m_out.print(">");
                }
                this.m_out.print(" )");
                this.m_out.println();
            }
            if (atomicRole.equals(AtomicRole.TOP_DATA_ROLE)) continue;
            for (HierarchyNode<AtomicRole> hierarchyNode2 : hierarchyNode.getChildNodes()) {
                AtomicRole atomicRole2;
                atomicRole2 = (AtomicRole)hierarchyNode2.getRepresentative();
                if (atomicRole2.equals(AtomicRole.BOTTOM_DATA_ROLE)) continue;
                this.m_out.print("SubDataPropertyOf( <");
                this.m_out.print(atomicRole2.getIRI());
                this.m_out.print("> <");
                this.m_out.print(atomicRole.getIRI());
                this.m_out.print("> )");
                this.m_out.println();
            }
        }
        this.m_out.println();
    }

    protected void print(Role role) {
        if (role instanceof AtomicRole) {
            this.print((AtomicRole)role);
        } else {
            this.m_out.print("ObjectInverseOf( ");
            this.print(((InverseRole)role).getInverseOf());
            this.m_out.print(" )");
        }
    }

    protected void print(AtomicRole atomicRole) {
        this.m_out.print("<");
        this.m_out.print(atomicRole.getIRI());
        this.m_out.print(">");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DataRoleComparator
    implements Comparator<AtomicRole> {
        public static final DataRoleComparator INSTANCE = new DataRoleComparator();

        protected DataRoleComparator() {
        }

        @Override
        public int compare(AtomicRole atomicRole, AtomicRole atomicRole2) {
            int n = this.getAtomicRoleClass(atomicRole) - this.getAtomicRoleClass(atomicRole2);
            if (n != 0) {
                return n;
            }
            return atomicRole.getIRI().compareTo(atomicRole2.getIRI());
        }

        protected int getAtomicRoleClass(AtomicRole atomicRole) {
            if (AtomicRole.BOTTOM_DATA_ROLE.equals(atomicRole)) {
                return 0;
            }
            if (AtomicRole.TOP_DATA_ROLE.equals(atomicRole)) {
                return 1;
            }
            return 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjectRoleComparator
    implements Comparator<Role> {
        public static final ObjectRoleComparator INSTANCE = new ObjectRoleComparator();

        protected ObjectRoleComparator() {
        }

        @Override
        public int compare(Role role, Role role2) {
            int n = this.getRoleClass(role) - this.getRoleClass(role2);
            if (n != 0) {
                return n;
            }
            n = this.getRoleDirection(role) - this.getRoleDirection(role2);
            if (n != 0) {
                return n;
            }
            return this.getInnerAtomicRole(role).getIRI().compareTo(this.getInnerAtomicRole(role2).getIRI());
        }

        protected int getRoleClass(Role role) {
            if (AtomicRole.BOTTOM_OBJECT_ROLE.equals(role)) {
                return 0;
            }
            if (AtomicRole.TOP_OBJECT_ROLE.equals(role)) {
                return 1;
            }
            return 2;
        }

        protected AtomicRole getInnerAtomicRole(Role role) {
            if (role instanceof AtomicRole) {
                return (AtomicRole)role;
            }
            return ((InverseRole)role).getInverseOf();
        }

        protected int getRoleDirection(Role role) {
            return role instanceof AtomicRole ? 0 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AtomicConceptComparator
    implements Comparator<AtomicConcept> {
        public static final AtomicConceptComparator INSTANCE = new AtomicConceptComparator();

        protected AtomicConceptComparator() {
        }

        @Override
        public int compare(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
            int n = this.getAtomicConceptClass(atomicConcept) - this.getAtomicConceptClass(atomicConcept2);
            if (n != 0) {
                return n;
            }
            return atomicConcept.getIRI().compareTo(atomicConcept2.getIRI());
        }

        protected int getAtomicConceptClass(AtomicConcept atomicConcept) {
            if (AtomicConcept.NOTHING.equals(atomicConcept)) {
                return 0;
            }
            if (AtomicConcept.THING.equals(atomicConcept)) {
                return 1;
            }
            return 2;
        }
    }
}

