test_mzXML <- function() {
    file <- system.file("threonine", "threonine_i2_e35_pH_tree.mzXML", package = "msdata")
    mzxml <- openMSfile(file, backend="Ramp")
    checkTrue(class(mzxml)=="mzRramp")
    show(mzxml)
    length(mzxml)
    runInfo(mzxml)
    instrumentInfo(mzxml)
    peaks(mzxml)
    peaks(mzxml,1)
    peaks(mzxml,2:3)
    peaksCount(mzxml)
    header(mzxml)
    header(mzxml,1)
    header(mzxml,2:3)
    fileName(mzxml)
    close(mzxml)
}

test_mzML <- function() {
    file <- system.file("microtofq", "MM14.mzML", package = "msdata")
    mzml <- openMSfile(file, backend="Ramp")
    checkTrue(class(mzml)=="mzRramp")
    show(mzml)
    length(mzml)
    runInfo(mzml)
    instrumentInfo(mzml)
    peaks(mzml)
    peaks(mzml,1)
    peaks(mzml,2:3)
    peaksCount(mzml)
    header(mzml)
    header(mzml,1)
    header(mzml,2:3)

    checkTrue(ncol(header(mzml))>4)
    checkTrue(length(header(mzml,1))>4)
    checkTrue(ncol(header(mzml,2:3))>4)

    fileName(mzml)
    close(mzml)    
}

test_mzData <- function() {
    file <- system.file("microtofq", "MM14.mzdata", package = "msdata")
    mzdata <- openMSfile(file, backend="Ramp")
    checkTrue(class(mzdata)=="mzRramp")
    show(mzdata)
    length(mzdata)
    runInfo(mzdata)
    checkTrue(all(instrumentInfo(mzdata)==""))
    peaks(mzdata)
    peaks(mzdata,1)
    peaks(mzdata,2:3)
    peaksCount(mzdata)
    header(mzdata,1)
    header(mzdata,2:3)
    fileName(mzdata)
    close(mzdata)    
}

test_mzData.gz <- function() {
    file <- system.file("microtofq", "MM14.mzdata.gz", package = "msdata")
    mzdata <- openMSfile(file, backend="Ramp")
    checkTrue(class(mzdata)=="mzRramp")
    show(mzdata)
    length(mzdata)
    runInfo(mzdata)
    checkTrue(all(instrumentInfo(mzdata)==""))
    peaks(mzdata)
    peaks(mzdata,1)
    peaks(mzdata,2:3)
    peaksCount(mzdata)
    header(mzdata,1)
    header(mzdata,2:3)
    fileName(mzdata)
    close(mzdata)    
}

