### R code from vignette source 'EISA_biclust.Rnw'

###################################################
### code chunk number 1: set width
###################################################
options(width=60)
options(continue=" ")
try(X11.options(type="xlib"), silent=TRUE)


###################################################
### code chunk number 2: packages
###################################################
library(biclust)
library(eisa)
library(ALL)
data(ALL)


###################################################
### code chunk number 3: filter
###################################################
library(GO.db)
library(hgu95av2.db)
gotable <- toTable(GOTERM)
myterms <- unique(gotable$go_id[gotable$Term %in% c("immune system process")])
myprobes <- unique(unlist(mget(myterms, hgu95av2GO2ALLPROBES)))
ALL.filtered <- ALL[myprobes,]


###################################################
### code chunk number 4: filtered
###################################################
nrow(ALL.filtered)


###################################################
### code chunk number 5: seed
###################################################
set.seed(0xf00)


###################################################
### code chunk number 6: bcplaid
###################################################
Bc <- biclust(exprs(ALL.filtered), BCPlaid(),
              fit.model = ~m + a + b, verbose = FALSE)


###################################################
### code chunk number 7: bcplaid result
###################################################
class(Bc)
Bc


###################################################
### code chunk number 8: convert bc to isa
###################################################
Bc <- annotate(Bc, ALL.filtered)
modules <- as(Bc, "ISAModules")
modules


###################################################
### code chunk number 9: biclust enrichment
###################################################
library(KEGG.db)
KEGG <- ISAKEGG(modules)
sigCategories(KEGG)[[2]]
unlist(mget(sigCategories(KEGG)[[2]], KEGGPATHID2NAME))


###################################################
### code chunk number 10: heatmap (eval = FALSE)
###################################################
## col <- ifelse(grepl("^B", ALL.filtered$BT), "white", "black")
## modcol <- col[ getSamples(modules, 2)[[1]] ]
## ISA2heatmap(modules, 2, ALL.filtered, 
##             ColSideColors=modcol)


###################################################
### code chunk number 11: heatmap-real
###################################################
col <- ifelse(grepl("^B", ALL.filtered$BT), "white", "black")
modcol <- col[ getSamples(modules, 2)[[1]] ]
ISA2heatmap(modules, 2, ALL.filtered, 
            ColSideColors=modcol)


###################################################
### code chunk number 12: profilePlot (eval = FALSE)
###################################################
## profilePlot(modules, 2, ALL, plot="both")


###################################################
### code chunk number 13: profilePlot-real
###################################################
profilePlot(modules, 2, ALL, plot="both")


###################################################
### code chunk number 14: psoptions
###################################################
ps.options(fonts=c("serif", "mono"))


###################################################
### code chunk number 15: GOtreeplot (eval = FALSE)
###################################################
## library(GO.db)
## GO <- ISAGO(modules)
## gog <- gograph(summary(GO$CC)[[3]])
## summary(gog)
## gographPlot(gog)


###################################################
### code chunk number 16: GOtreeplot-real
###################################################
library(GO.db)
GO <- ISAGO(modules)
gog <- gograph(summary(GO$CC)[[3]])
summary(gog)
gographPlot(gog)


###################################################
### code chunk number 17: html
###################################################
CHR <- ISACHR(modules)
htmldir <- tempdir()
ISAHTML(eset=ALL.filtered, modules=modules, target.dir=htmldir, 
        GO=GO, KEGG=KEGG, CHR=CHR, condPlot=FALSE)


###################################################
### code chunk number 18: html-show (eval = FALSE)
###################################################
## if (interactive()) {
##   browseURL(URLencode(paste("file://", htmldir, "/index.html", sep="")))
## }


###################################################
### code chunk number 19: mnplot (eval = FALSE)
###################################################
## group <- ifelse(grepl("^B", ALL.filtered$BT), "B-cell", "T-cell")
## ISAmnplot(modules, 2, ALL.filtered, norm="raw", group=group)


###################################################
### code chunk number 20: mnplot-real
###################################################
group <- ifelse(grepl("^B", ALL.filtered$BT), "B-cell", "T-cell")
ISAmnplot(modules, 2, ALL.filtered, norm="raw", group=group)


###################################################
### code chunk number 21: load isa data
###################################################
data(ALLModules)
ALLModules


###################################################
### code chunk number 22: isa to biclust
###################################################
BcMods <- as(ALLModules, "Biclust")
BcMods


###################################################
### code chunk number 23: coherence
###################################################
data <- exprs(ALL[featureNames(ALLModules),])
constantVariance(data, BcMods, 1)
additiveVariance(data, BcMods, 1)
multiplicativeVariance(data, BcMods, 1)
signVariance(data, BcMods, 1)


###################################################
### code chunk number 24: coherence vs robustness
###################################################
cV <- sapply(1:BcMods@Number, function(x) constantVariance(data, BcMods, x))
aV <- sapply(1:BcMods@Number, function(x) additiveVariance(data, BcMods, x))
mV <- sapply(1:BcMods@Number, function(x) multiplicativeVariance(data, BcMods, x))
sV <- sapply(1:BcMods@Number, function(x) signVariance(data, BcMods, x))
rob <- ISARobustness(ALL, ALLModules)


###################################################
### code chunk number 25: pairs (eval = FALSE)
###################################################
## panel.low <- function(x, y) {
##   usr <- par("usr")
##   m <- c((usr[2]+usr[1])/2, (usr[4]+usr[3])/2)
##   text(m[1], m[2], adj=c(1/2,1/2), cex=1.5,
##        paste(sep="\n", "Correlation:", round(cor(x,y),2)))
## }
## pairs( cbind(cV, aV, mV, sV, rob), lower.panel=panel.low )


###################################################
### code chunk number 26: pairs-real
###################################################
panel.low <- function(x, y) {
  usr <- par("usr")
  m <- c((usr[2]+usr[1])/2, (usr[4]+usr[3])/2)
  text(m[1], m[2], adj=c(1/2,1/2), cex=1.5,
       paste(sep="\n", "Correlation:", round(cor(x,y),2)))
}
pairs( cbind(cV, aV, mV, sV, rob), lower.panel=panel.low )


###################################################
### code chunk number 27: sessioninfo
###################################################
toLatex(sessionInfo())


