## ----include=FALSE-------------------------------------------------------
library(DOSE)
library(GO.db)
library(org.Hs.eg.db)
library(pathview)
library(clusterProfiler)
library(knitr)
opts_chunk$set(tidy=TRUE,tidy.opts=list(keep.blank.line=FALSE, width.cutoff=50),out.truncate=80,out.lines=6,cache=TRUE,dev='pdf',include=TRUE,fig.width=6,fig.height=6,resolution=150)

## ----options,echo=FALSE-------------------------------------------------------
options(digits=3, width=80, prompt=" ", continue=" ")

## ----groupGO------------------------------------------------------------------
require(DOSE)
data(geneList)
gene <- names(geneList)[abs(geneList) > 2]
head(gene)
ggo <- groupGO(gene=gene, organism="human",
				ont="BP", level=3, readable=TRUE)
head(summary(ggo))

## ----enrichGO-----------------------------------------------------------------
ego <- enrichGO(gene=gene,
                universe = names(geneList),
                organism="human",
                ont="CC",
                pvalueCutoff=0.01,
                readable=TRUE)
head(summary(ego))

## ----gseGO--------------------------------------------------------------------
ego2 <- gseGO(geneList=geneList,
              organism="human",
              ont="CC",
              nPerm=100,
              minGSSize=120,
              pvalueCutoff=0.01,
              verbose=FALSE)
head(summary(ego2))

## ----enrichKEGG---------------------------------------------------------------
kk <- enrichKEGG(gene=gene,
                 organism="human",
                 pvalueCutoff=0.01, 
                 readable=TRUE)
head(summary(kk))

## ----gseKEGG------------------------------------------------------------------
kk2 <- gseKEGG(geneList=geneList,
               organism="human",
               nPerm=100,
               minGSSize=120,
               pvalueCutoff=0.01,
               verbose=FALSE)
head(summary(kk2))

## ----barplot, fig.height=5, fig.width=6---------------------------------------
barplot(ggo, drop=TRUE, showCategory=12)

## ----barplot-enrich, fig.height=5, fig.width=8--------------------------------
barplot(ego, showCategory=8)

## ----enrichMap, fig.cap="enrichment map of enrichment result", fig.align="center", fig.height=16, fig.width=16, out.width="0.9\\textwidth", fig.pos="h"----
enrichMap(ego)

## ----enrichMap2, fig.cap="enrichment map of gsea result", fig.align="center", fig.height=16, fig.width=16, out.width="0.9\\textwidth", fig.pos="h"----
enrichMap(ego2)

## ----cnetplot, fig.height=14, fig.width=14------------------------------------
cnetplot(ego, categorySize="pvalue", foldChange=geneList)

## ----cnetplot-KEGG, fig.height=14, fig.width=14-------------------------------
cnetplot(kk, categorySize="geneNum", foldChange=geneList)

## ----gseaplot, fig.cap="plotting gsea result", fig.align="center", fig.height=6, fig.width=6, out.width="0.6\\textwidth", fig.pos="h"----
gseaplot(kk2, geneSetID = "hsa04145")

## ----viewKEGG-----------------------------------------------------------------
require(pathview)
hsa04110 <- pathview(gene.data=geneList, pathway.id="hsa04110", species="hsa", limit=list(gene=max(abs(geneList)), cpd=1))

## ----compareCluster, fig.height=8, fig.width=8--------------------------------
data(gcSample)
ck <- compareCluster(geneCluster=gcSample, fun="enrichKEGG")
plot(ck)

## ----sessInfo, results='asis', echo=FALSE-------------------------------------
toLatex(sessionInfo())

