### R code from vignette source 'ToPASeq.Rnw'

###################################################
### code chunk number 1: ToPASeq.Rnw:80-81
###################################################
options(width=60)


###################################################
### code chunk number 2: lib
###################################################
library(ToPASeq)
library(DEGraph)
data(Loi2008_DEGraphVignette)
pathways<-kegg[1:5]
ls()


###################################################
### code chunk number 3: ToPASeq.Rnw:101-130 (eval = FALSE)
###################################################
## top<-TopologyGSA(exprLoi2008, classLoi2008, pathways, type="MA", nperm=200)
## #99 node labels mapped to the expression data
## #Average coverage 31.47657 %
## #0 (out of 5) pathways without a mapped node
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## res(top)
## #                                        t.value df.mean1 df.mean2 p.value
## #Acute myeloid leukemia                 3080.663       30      224   0.000
## #Adherens junction                      1102.830       10      244   0.040
## #Adipocytokine signaling pathway        3196.432       25      229   0.000
## #Adrenergic signaling in cardiomyocytes 2178.476       26      228   0.055
## #African trypanosomiasis                1400.088        8      246   0.000
## #                                       lambda.value df.var  p.value.var
## #Acute myeloid leukemia                    217.92044    165 3.622794e-03
## #Adherens junction                          39.92094     10 1.749659e-05
## #Adipocytokine signaling pathway           192.81336    121 3.595452e-05
## #Adrenergic signaling in cardiomyocytes    169.47418     80 2.211953e-08
## #African trypanosomiasis                    13.77192     15 5.428926e-01
## #                                       qchisq.value var.equal
## #Acute myeloid leukemia                    195.97336         1
## #Adherens junction                          18.30704         1
## #Adipocytokine signaling pathway           147.67353         1
## #Adrenergic signaling in cardiomyocytes    101.87947         1
## #African trypanosomiasis                    24.99579         0
## 


###################################################
### code chunk number 4: ToPASeq.Rnw:140-142
###################################################
deg<-DEGraph(exprLoi2008, classLoi2008, pathways, type="MA")
res(deg)


###################################################
### code chunk number 5: ToPASeq.Rnw:153-187 (eval = FALSE)
###################################################
## cli<-Clipper( exprLoi2008, classLoi2008, pathways,type="MA", test="mean")
## #99 node labels mapped to the expression data
## #Average coverage 31.47657 %
## #0 (out of 5) pathways without a mapped node
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## res(cli)
## #                                       alphaVar alphaMean  maxScore activation
## #Acute myeloid leukemia                    0.788     0.008  4.336307  0.1255490
## #Adherens junction                         0.087     0.027        NA         NA
## #Adipocytokine signaling pathway           0.675     0.000 33.209403  0.8012589
## #Adrenergic signaling in cardiomyocytes    0.108     0.042        NA         NA
## #African trypanosomiasis                   0.966     0.005        NA         NA
## #                                          impact
## #Acute myeloid leukemia                 0.3846154
## #Adherens junction                             NA
## #Adipocytokine signaling pathway        0.5000000
## #Adrenergic signaling in cardiomyocytes        NA
## #African trypanosomiasis                       NA
## #                                                                                                                                                                                                                                                                                    involvedGenes
## #Acute myeloid leukemia                                                                                                                                                                                                                                              2475;6199;1978;2475;2475;6198
## #Adherens junction                                                                                                                                                                                                                                                                              NA
## #Adipocytokine signaling pathway        32;51422;53632;5562;5563;5564;5565;5571;2538;51422;53632;5562;5563;5564;5565;5571;5105;51422;53632;5562;5563;5564;5565;5571;5106;51422;53632;5562;5563;5564;5565;5571;51422;53632;5562;5563;5564;5565;5571;57818;51422;53632;5562;5563;5564;5565;5571;6517
## #Adrenergic signaling in cardiomyocytes                                                                                                                                                                                                                                                         NA
## #African trypanosomiasis                                                                                                                                                                                                                                                                        NA
## #                                                                                                                                                                                                                                                                                        pathGenes
## #Acute myeloid leukemia                                                                                                                                                     10000;207;208;23533;3265;3845;4893;5290;5291;5293;5294;5295;5296;8503,10000;207;208;2475,2475;6199,1978;2475,2475;6198
## #Adherens junction                                                                                                                                                                                                                                                                              NA
## #Adipocytokine signaling pathway        32;51422;53632;5562;5563;5564;5565;5571,2538;51422;53632;5562;5563;5564;5565;5571,5105;51422;53632;5562;5563;5564;5565;5571,5106;51422;53632;5562;5563;5564;5565;5571,51422;53632;5562;5563;5564;5565;5571;57818,51422;53632;5562;5563;5564;5565;5571;6517
## #Adrenergic signaling in cardiomyocytes                                                                                                                                                                                                                                                         NA
## #African trypanosomiasis                                                                                                                                                                                                                                                                        NA


###################################################
### code chunk number 6: ToPASeq.Rnw:196-198
###################################################
spi<-SPIA(exprLoi2008, classLoi2008,pathways , type="MA", logFC.th=-1)
res(spi)


###################################################
### code chunk number 7: ToPASeq.Rnw:206-208
###################################################
tap<-TAPPA(exprLoi2008, classLoi2008, pathways, type="MA")
res(tap)


###################################################
### code chunk number 8: ToPASeq.Rnw:217-238 (eval = FALSE)
###################################################
## tbs<-TBS( exprLoi2008, classLoi2008, pathways, type="MA",  logFC.th=-1, nperm=100)
## #99 node labels mapped to the expression data
## #Average coverage 31.47657 %
## #0 (out of 5) pathways without a mapped node
## #0 denoted as 0
## # 1 denoted as 1
## # Contrasts:  0 - 1
## #Found 40 differentially expressed genes
## #Preparing permutation table and downstream list
## #Observed scores..
## #Random scores..
## #100
## #Normalization and p-values...
## res(tbs)
## #                                       TBS.obs.norm    p     p.adj
## #Acute myeloid leukemia                   -0.8012546 0.90 0.9000000
## #Adherens junction                         2.9052652 0.03 0.1250000
## #Adipocytokine signaling pathway           0.8461749 0.10 0.1666667
## #Adrenergic signaling in cardiomyocytes   -0.5548923 0.80 0.9000000
## #African trypanosomiasis                   1.5028307 0.05 0.1250000
## 


###################################################
### code chunk number 9: ToPASeq.Rnw:246-268 (eval = FALSE)
###################################################
## pwe<-PWEA(exprLoi2008, classLoi2008, pathways,  type="MA", nperm=100)
## #99 node labels mapped to the expression data
## #Average coverage 31.47657 %
## #0 (out of 5) pathways without a mapped node
## #0 denoted as 0
## # 1 denoted as 1
## # Contrasts:  0 - 1
## #Preparing data..
## #100
## #Processing gene set:
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## res(pwe)
## #                                              ES    p p.adj
## #Acute myeloid leukemia                 0.1995347 0.81  0.81
## #Adherens junction                      0.5757274 0.67  0.81
## #Adipocytokine signaling pathway        0.3272288 0.32  0.81
## #Adrenergic signaling in cardiomyocytes 0.3888446 0.68  0.81
## #African trypanosomiasis                0.3544996 0.46  0.81


###################################################
### code chunk number 10: ToPASeq.Rnw:280-285
###################################################
library(gageData)
data(hnrnp.cnts)
hnrnp.cnts<-hnrnp.cnts[rowSums(hnrnp.cnts)>0,]
group<-c(rep("sample",4), rep("control",4))
pathways<-kegg[1:10]


###################################################
### code chunk number 11: ToPASeq.Rnw:296-315 (eval = FALSE)
###################################################
## top<-TopologyGSA(hnrnp.cnts, group, pathways[1:3], type="RNASeq", nperm=1000)
## #528 node labels mapped to the expression data
## #Average coverage 83.16538
## #0 (out of 10) pathways without a mapped node
## #Normalization method was not specified. TMM used as default
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## #Alanine, aspartate and glutamate metabolism
## #Aldosterone-regulated sodium reabsorption
## #Allograft rejection
## #alpha-Linolenic acid metabolism
## 
## res(top)
## #data frame with 0 columns and 1 rows
## 
## 


###################################################
### code chunk number 12: ToPASeq.Rnw:327-329
###################################################
deg<-DEGraph(hnrnp.cnts, group, pathways, type="RNASeq")
res(deg)[,1:4]


###################################################
### code chunk number 13: ToPASeq.Rnw:340-362 (eval = FALSE)
###################################################
## cli<-Clipper(hnrnp.cnts, group, pathways, type="RNASeq", test="mean")
## #528 node labels mapped to the expression data
## #Average coverage 83.16538
## #0 (out of 10) pathways without a mapped node
## #Normalization method was not specified. TMM used as default
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## #Alanine, aspartate and glutamate metabolism
## #Alcoholism
## #Aldosterone-regulated sodium reabsorption
## #Allograft rejection
## #alpha-Linolenic acid metabolism
## res(cli)[1:2,]
## #                       alphaVar alphaMean  maxScore activation    impact                                               involvedGenes
## #Acute myeloid leukemia    0.022     0.008 18.290959  0.3782696 0.2592593 3728;4609;3728;5467;3728;595;3728;6932;3728;6934;3728;83439
## #Adherens junction         0.035     0.018  1.956012  0.1415808 0.1052632                                    4087;4088;4089;7046;7048
## #                                                                                            pathGenes
## #Acute myeloid leukemia 3728;5371;5914;861,3728;4609,3728;5467,3728;595,3728;6932,3728;6934,3728;83439
## #Adherens junction                                        2260;6615;7046;7048,4087;4088;4089;7046;7048


###################################################
### code chunk number 14: ToPASeq.Rnw:371-373
###################################################
spi<-SPIA(hnrnp.cnts, group, pathways, type="RNASeq", logFC.th=-1)
res(spi)


###################################################
### code chunk number 15: ToPASeq.Rnw:381-383
###################################################
tap<-TAPPA(hnrnp.cnts, group, pathways, type="RNASeq")
res(tap)


###################################################
### code chunk number 16: ToPASeq.Rnw:392-415 (eval = FALSE)
###################################################
## tbs<-TBS(hnrnp.cnts, group, pathways, type="RNASeq",  logFC.th=-1, nperm=100)
## #528 node labels mapped to the expression data
## #Average coverage 83.16538
## #0 (out of 10) pathways without a mapped node
## #test was not specified. 'vstlimma' used as default
## #Found 5702 differentially expressed genes
## #Preparing permutation table and downstream list
## #Observed scores..
## #Random scores..
## #100
## #Normalization and p-values...
## res(tbs)
## #                                            TBS.obs.norm    p      p.adj
## #Acute myeloid leukemia                        -1.6325413 0.05 0.06250000
## #Adherens junction                             -3.9416308 0.01 0.01666667
## #Adipocytokine signaling pathway               -3.1989858 0.00 0.00000000
## #Adrenergic signaling in cardiomyocytes       -16.1777366 0.00 0.00000000
## #African trypanosomiasis                       -4.0834773 0.00 0.00000000
## #Alanine, aspartate and glutamate metabolism    0.0137086 0.44 0.48888889
## #Alcoholism                                    -4.1997338 0.00 0.00000000
## #Aldosterone-regulated sodium reabsorption      1.9996012 1.00 1.00000000
## #Allograft rejection                           -3.4004380 0.01 0.01666667
## #alpha-Linolenic acid metabolism               -2.6720346 0.02 0.02857143                                                0.0000000


###################################################
### code chunk number 17: ToPASeq.Rnw:423-452 (eval = FALSE)
###################################################
## pwe<-PWEA(hnrnp.cnts, group, pathways, type="RNASeq", nperm=100)
## #528 node labels mapped to the expression data
## #Average coverage 83.16538
## #0 (out of 10) pathways without a mapped node
## #test was not specified. 'vstlimma' used as default
## #Preparing data..
## #1  2  3  4  5  6  7  8  9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32  33  34  35  36  37  38  39  40  41  42  43  44  45  46  47  48  49  50  51  52  53  54  55  56  57  58  59  60  61  62  63  64  65  66  67  68  69  70  71  72  73  74  75  76  77  78  79  80  81  82  83  84  85  86  87  88  89  90  91  92  93  94  95  96  97  98  99  100  Processing gene set:
## #Acute myeloid leukemia
## #Adherens junction
## #Adipocytokine signaling pathway
## #Adrenergic signaling in cardiomyocytes
## #African trypanosomiasis
## #Alanine, aspartate and glutamate metabolism
## #Alcoholism
## #Aldosterone-regulated sodium reabsorption
## #Allograft rejection
## #alpha-Linolenic acid metabolism
## res(pwe)
## #                                                   ES    p     p.adj
## #Acute myeloid leukemia                      0.3526104 0.29 0.4142857
## #Adherens junction                           0.3829831 1.00 1.0000000
## #Adipocytokine signaling pathway             0.3102945 1.00 1.0000000
## #Adrenergic signaling in cardiomyocytes      0.3611207 0.20 0.3333333
## #African trypanosomiasis                     0.3272899 0.20 0.3333333
## #Alanine, aspartate and glutamate metabolism 0.2720946 0.20 0.3333333
## #Alcoholism                                  0.4708293 0.86 1.0000000
## #Aldosterone-regulated sodium reabsorption   0.3951037 0.20 0.3333333
## #Allograft rejection                         0.9421248 0.03 0.3000000
## #alpha-Linolenic acid metabolism             0.6587026 0.20 0.3333333


###################################################
### code chunk number 18: ToPASeq.Rnw:473-482
###################################################
library(gageData)
data(hnrnp.cnts)

group<-c(rep("sample",4), rep("control",4))
hnrnp.cnts<-hnrnp.cnts[rowSums(hnrnp.cnts)>0,]
cli<-Clipper(hnrnp.cnts, group, kegg[1:2], type="RNASeq", testCliques=TRUE)

plot(cli,1, kegg)



###################################################
### code chunk number 19: ToPASeq.Rnw:492-500 (eval = FALSE)
###################################################
## library(gageData)
## data(hnrnp.cnts)
## 
## group<-c(rep("sample",4), rep("control",4))
## hnrnp.cnts<-hnrnp.cnts[rowSums(hnrnp.cnts)>0,]
## spi<-SPIA(hnrnp.cnts, group, kegg[45:50], type="RNASeq", logFC.th=-1)
## plot(spi,"Complement and coagulation cascades", kegg[45:50], fontsize=50)
## 


