## ------------------------------------------------------------------------
library(TSCAN)
data(lpsdata)
procdata <- preprocess(lpsdata)

## ------------------------------------------------------------------------
STAT2expr <- log2(lpsdata["STAT2",]+1)
lpspseudotime <- TSPpseudotime(procdata, geneexpr = STAT2expr, dim = 2)

## ------------------------------------------------------------------------
plotpseudotime(lpspseudotime, markerexpr = STAT2expr)

## ------------------------------------------------------------------------
diffval <- difftest(procdata,lpspseudotime[[1]])
#Selected differentially expressed genes under qvlue cutoff of 0.05
head(row.names(diffval)[diffval$qval < 0.05])

## ------------------------------------------------------------------------
singlegeneplot(STAT2expr, lpspseudotime[[1]])

## ------------------------------------------------------------------------
subpopulation <- data.frame(cell = colnames(procdata), sub = ifelse(grepl("Unstimulated",colnames(procdata)),0,1), stringsAsFactors = FALSE)
#Comparing ordering with or without marker gene information
order1 <- TSPpseudotime(procdata, geneexpr = STAT2expr, dim = 2)
order2 <- TSPpseudotime(procdata, dim = 2)
orders <- list(order1[[1]],order2[[1]])

## ------------------------------------------------------------------------
orderscore(subpopulation, orders)

