### R code from vignette source 'SigCheck.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: loadData
###################################################
library(breastCancerNKI)
data(nki)
nki


###################################################
### code chunk number 3: showPhenoData
###################################################
varLabels(nki)


###################################################
### code chunk number 4: tDMFS
###################################################
nki$t.dmfs


###################################################
### code chunk number 5: eDMFS
###################################################
nki$e.dmfs


###################################################
### code chunk number 6: excludeNA
###################################################
dim(nki)
nki <- nki[,!is.na(nki$e.dmfs)]
dim(nki)


###################################################
### code chunk number 7: loadKnown
###################################################
library(SigCheck)
data(knownSignatures)
names(knownSignatures)


###################################################
### code chunk number 8: getVANTVEER
###################################################
names(knownSignatures$cancer)
vantveer <- knownSignatures$cancer$VANTVEER
vantveer


###################################################
### code chunk number 9: showFeatureAnno
###################################################
fvarLabels(nki)


###################################################
### code chunk number 10: sigCheck1 (eval = FALSE)
###################################################
## nkiResults <- sigCheck(nki, classes="e.dmfs", annotation="HUGO.gene.symbol",
##                    signature=vantveer, validationSamples=275:319, 
##                    knownSignatures="cancer",nIterations=1000)


###################################################
### code chunk number 11: loadResults
###################################################
data(nkiResults)


###################################################
### code chunk number 12: classifierResults
###################################################
nkiResults$checkClassifier


###################################################
### code chunk number 13: mode1
###################################################
sum(nki$e.dmfs[1:274]==0)
sum(nki$e.dmfs[1:274]==1)


###################################################
### code chunk number 14: mode2
###################################################
sum(nki$e.dmfs[274:319]==0)
sum(nki$e.dmfs[274:319]==1)


###################################################
### code chunk number 15: sigCheckNKIRandom
###################################################
sigCheckPlot(nkiResults[[2]])


###################################################
### code chunk number 16: sigCheckNKIKnown
###################################################
sigCheckPlot(nkiResults[[3]])


###################################################
### code chunk number 17: perfKnown
###################################################
knownHigh <- nkiResults$checkKnown$performanceKnown > 
               nkiResults$checkClassifier$sigPerformance
nkiResults$checkKnown$performanceKnown[knownHigh]


###################################################
### code chunk number 18: sigCheckNKIPermuteFeature
###################################################
sigCheckPlot(nkiResults[[4]])


###################################################
### code chunk number 19: sigCheckNKIPermuteCategory
###################################################
sigCheckPlot(nkiResults[[5]])


###################################################
### code chunk number 20: loo
###################################################
results <- sigCheckClassifier(nki, classes="e.dmfs", 
                             signature=vantveer, 
                             annotation="HUGO.gene.symbol")
results


###################################################
### code chunk number 21: multicoreparam
###################################################
CoresToUse <- 6
library(BiocParallel)
mcp <- MulticoreParam(workers=CoresToUse)
register(mcp, default=TRUE)


###################################################
### code chunk number 22: setcores
###################################################
options(mc.cores=CoresToUse)


###################################################
### code chunk number 23: sessionInfo
###################################################
toLatex(sessionInfo())


