## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----load, message=FALSE-------------------------------------------------
library(Rqc)

## ----file_loc------------------------------------------------------------
folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")

## ----, rqc, eval=FALSE---------------------------------------------------
#  rqc(path = folder, pattern = ".fastq.gz")

## ----example, echo=FALSE, message=FALSE----------------------------------
fastqDir <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
files <- list.files(fastqDir, "fastq.gz", full.names=TRUE)
rqcResultSet <- rqcQA(files = files)

## ----average-quality-plot, fig.width=10----------------------------------
rqcReadQualityPlot(rqcResultSet)

## ----cycle-average-quality-plot, fig.width=10----------------------------
rqcCycleAverageQualityPlot(rqcResultSet)

## ----read-width-plot, fig.width=10---------------------------------------
rqcReadWidthPlot(rqcResultSet)

## ----cycle-gc-plot, fig.width=10-----------------------------------------
rqcCycleGCPlot(rqcResultSet)

## ----cycle-quality-plots, fig.width=10-----------------------------------
rqcCycleQualityPlot(rqcResultSet)

## ----cycle-quality-boxplots, fig.width=10--------------------------------
rqcCycleQualityBoxPlot(rqcResultSet)

## ----cycle-basecall-plots, fig.width=10----------------------------------
rqcCycleBaseCallsPlot(rqcResultSet)

## ----cycle-basecall-lineplots, fig.width=10------------------------------
rqcCycleBaseCallsLinePlot(rqcResultSet)

## ----input---------------------------------------------------------------
fastqDir <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
files <- list.files(fastqDir, "fastq.gz", full.names=TRUE)

## ----rqcQA---------------------------------------------------------------
rqcResultSet <- rqcQA(files = files)

## ----report, eval=FALSE--------------------------------------------------
#  reportFile <- rqcReport(rqcResultSet)
#  browseURL(reportFile)

## ----calc----------------------------------------------------------------
df <- rqcCycleAverageQualityCalc(rqcResultSet)
plot(df$cycle, df$quality, col = df$filename, xlab='Cycle', ylab='Quality Score')

## ----subset, fig.width=10------------------------------------------------
sublist <- rqcResultSet[1]
rqcCycleQualityPlot(sublist)

## ------------------------------------------------------------------------
sessionInfo()

