### R code from vignette source 'RMassBankXCMS.Rnw'

###################################################
### code chunk number 1: RMassBankXCMS.Rnw:24-26
###################################################
options(width=74)
#library(xtable)


###################################################
### code chunk number 2: RMassBankXCMS.Rnw:67-69
###################################################
library(RMassBank)
library(RMassBankData)


###################################################
### code chunk number 3: RMassBankXCMS.Rnw:78-92
###################################################
RmbDefaultSettings()
rmbo <- getOption("RMassBank")
rmbo$spectraList <- list(
  list(mode="CID", ces="10eV", ce="10eV", res=12000),
  list(mode="CID", ces="20eV", ce="20eV", res=12000)
)

rmbo$annotations$instrument <- "Bruker micrOTOFq"
rmbo$annotations$instrument_type <- "LC-ESI-QTOF"
rmbo$recalibrator$MS1 <- "recalibrate.identity"
rmbo$recalibrator$MS2 <- "recalibrate.identity"
options("RMassBank" = rmbo)




###################################################
### code chunk number 4: RMassBankXCMS.Rnw:99-100
###################################################
msmsList <- newMsmsWorkspace()


###################################################
### code chunk number 5: RMassBankXCMS.Rnw:106-109
###################################################
msmsList@files <- list.files(system.file("spectra.Glucolesquerellin",
                                         package = "RMassBankData"),
                             "Glucolesquerellin.*mzData", full.names=TRUE)


###################################################
### code chunk number 6: RMassBankXCMS.Rnw:117-118
###################################################
loadList(system.file("list/PlantDataset.csv",package="RMassBankData"))


###################################################
### code chunk number 7: RMassBankXCMS.Rnw:127-131
###################################################
Args <- list(method="centWave",
                     peakwidth=c(5,12),
                     prefilter=c(0,0),
                     ppm=25, snthr=2)


###################################################
### code chunk number 8: RMassBankXCMS.Rnw:136-139
###################################################
msmsList <- msmsRead(msmsList, files= msmsList@files, readMethod = "xcms", mode = "mH", Args = Args)
msmsList <- msmsWorkflow(msmsList, steps=2:8,
                                 mode="mH", readMethod="xcms")


###################################################
### code chunk number 9: RMassBankXCMS.Rnw:150-156 (eval = FALSE)
###################################################
## msmsPeaklist <- newMsmsWorkspace()
## msmsPeaklist@files <- list.files(system.file("spectra.Glucolesquerellin",
##                                                      package = "RMassBankData"),
##                                          "Glucolesquerellin.*csv", full.names=TRUE)
## msmsPeaklist <- msmsWorkflow(msmsPeaklist, steps=1:8,
##                                      mode="mH", readMethod="peaklist")


###################################################
### code chunk number 10: RMassBankXCMS.Rnw:164-170
###################################################
mb <- newMbWorkspace(msmsList)
mb <- resetInfolists(mb)
mb <- loadInfolist(mb,system.file("infolists/PlantDataset.csv",
                                  package = "RMassBankData"))
## Step
mb <- mbWorkflow(mb, steps=1:8)


###################################################
### code chunk number 11: RMassBankXCMS.Rnw:178-179
###################################################
sessionInfo()


