## ----style, echo = FALSE-------------------------------------------------
BiocStyle::markdown()

## ----, env, echo=FALSE, message=FALSE, warning=FALSE---------------------
library("Pbase")

## ----, fa, cache=TRUE----------------------------------------------------
library("Biostrings")
fafile <- system.file("extdata/HUMAN_2014_06-09prots.fasta", package = "Pbase")
fa <- readAAStringSet(fafile)
fa

## ----, psm, cache=TRUE---------------------------------------------------
library("mzID")
idfile <- system.file("extdata/Thermo_Hela_PRTC_1_selected.mzid", package = "Pbase")
id <- flatten(mzID(idfile))
dim(id)
head(id)

## ----, p, cache=TRUE-----------------------------------------------------
library("Pbase")
p <- Proteins(fafile)
p <- addIdentificationData(p, idfile)
p

## ----, paccess-----------------------------------------------------------
aa(p)
pranges(p)
pfeatures(p)

## ----, metadata----------------------------------------------------------
metadata(p)
head(acols(p))
head(pcols(p))

## ----, pplot, fig.align='center', cache=TRUE-----------------------------
seqnames(p)
plot(p[c(1,9)])

## ----, si----------------------------------------------------------------
sessionInfo()

