### R code from vignette source 'MethylMix.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: golub (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite(MethylMix)


###################################################
### code chunk number 3: TCGAgbmLoad
###################################################
library(MethylMix)
data(METcancer)
head(METcancer)


###################################################
### code chunk number 4: TCGAgbmLoad
###################################################
library(MethylMix)
data(METnormal)
head(METnormal)


###################################################
### code chunk number 5: TCGAgbmLoad
###################################################
library(MethylMix)
data(MAcancer)
head(MAcancer)


###################################################
### code chunk number 6: TCGAgbmLoad (eval = FALSE)
###################################################
## library(IlluminaHumanMethylation27k.db)
## ProbeToSymbol <- IlluminaHumanMethylation27kSYMBOL
## mapped_probes <- mappedkeys(ProbeToSymbol)
## mapped_probes_List <- as.list(ProbeToSymbol[mapped_probes])
## mapped_probes_List[3:4]


###################################################
### code chunk number 7: TCGAgbmLoad
###################################################
library(MethylMix)
data(METcancer)
data(METnormal)
data(MAcancer)


###################################################
### code chunk number 8: MethylMixRun (eval = FALSE)
###################################################
## MethylMixResults = MethylMix(METcancer,METnormal,MAcancer)


###################################################
### code chunk number 9: TCGAgbmLoad
###################################################
data(METcancer_CDH1)
data(METnormal_CDH1)
data(MAcancer_CDH1)


###################################################
### code chunk number 10: CDH1clustering
###################################################
ProbeCorrelation=cor(t(METcancer_CDH1),method='pearson')
ClusterResults=hclust(as.dist(1-ProbeCorrelation), method = "complete", 
                      members = NULL)
plot(ClusterResults)


###################################################
### code chunk number 11: CDH1summary
###################################################
METcancer_CDH1_Clustered=matrix(0,0,length(colnames(METcancer_CDH1)))
METnormal_CDH1_Clustered=matrix(0,0,length(colnames(METnormal_CDH1)))
Clusternames=c()
Clusters=cutree(ClusterResults,h=0.7)
GeneProbes=rownames(METcancer_CDH1)
for (i in 1:length(unique(Clusters))) {
     tmpGeneProbes=GeneProbes[Clusters==i]
     if (length(tmpGeneProbes)>1) {
          tmpAveragedProfile=colMeans(METcancer_CDH1[tmpGeneProbes,])
          METcancer_CDH1_Clustered=rbind(METcancer_CDH1_Clustered,
                                         tmpAveragedProfile)          
          # Same for normal
          tmpAveragedProfile=colMeans(METnormal_CDH1[tmpGeneProbes,])
          METnormal_CDH1_Clustered=rbind(METnormal_CDH1_Clustered,
                                         tmpAveragedProfile)
     } else {          
          METcancer_CDH1_Clustered=rbind(METcancer_CDH1_Clustered,
                                         METcancer_CDH1[tmpGeneProbes,])
          METnormal_CDH1_Clustered=rbind(METnormal_CDH1_Clustered,
                                         METnormal_CDH1[tmpGeneProbes,])
     }
     Clusternames=c(Clusternames,paste('CDH1---Cluster',i,sep=""))
}
rownames(METcancer_CDH1_Clustered)=Clusternames
rownames(METnormal_CDH1_Clustered)=Clusternames


###################################################
### code chunk number 12: CDH1methylmix (eval = FALSE)
###################################################
## MethylMixResults=MethylMix(METcancer_CDH1_Clustered,METnormal_CDH1_Clustered,
##                            MAtumor_CDH1,OutputRoot='',Parallel=FALSE)
## MethylMix_PlotModel('CDH1---Cluster3',METcancer_CDH1_Clustered,MethylMixResults,
##                     MAtumor_CDH1,METnormal_CDH1_Clustered)


###################################################
### code chunk number 13: sessionInfo
###################################################
toLatex(sessionInfo())


