/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.cytoscape.equations.Tokeniser;

public class TokeniserTest
extends TestCase {
    public void testScanner1() throws Exception {
        String tokenAsString;
        Tokeniser tokeniser = new Tokeniser("AND(1.0 >= $(BOB), OR($(JOE) = $(tiny), $(x) > LOG(1.3e17)))");
        ArrayList<TokenStringRepAndPosition> tokens = new ArrayList<TokenStringRepAndPosition>();
        do {
            tokenAsString = tokeniser.getTokenAsString();
            int position = tokeniser.getStartPos();
            tokens.add(new TokenStringRepAndPosition(tokenAsString, position));
        } while (tokenAsString != "EOS");
        TokenStringRepAndPosition[] actualTokens = new TokenStringRepAndPosition[tokens.size()];
        tokens.toArray(actualTokens);
        TokenStringRepAndPosition[] expectedTokens = new TokenStringRepAndPosition[]{new TokenStringRepAndPosition("IDENTIFIER: \"AND\"", 0), new TokenStringRepAndPosition("OPEN_PAREN", 3), new TokenStringRepAndPosition("FLOAT_CONSTANT: \"1.0\"", 4), new TokenStringRepAndPosition("GREATER_OR_EQUAL", 8), new TokenStringRepAndPosition("DOLLAR", 11), new TokenStringRepAndPosition("OPEN_PAREN", 12), new TokenStringRepAndPosition("IDENTIFIER: \"BOB\"", 13), new TokenStringRepAndPosition("CLOSE_PAREN", 16), new TokenStringRepAndPosition("COMMA", 17), new TokenStringRepAndPosition("IDENTIFIER: \"OR\"", 19), new TokenStringRepAndPosition("OPEN_PAREN", 21), new TokenStringRepAndPosition("DOLLAR", 22), new TokenStringRepAndPosition("OPEN_PAREN", 23), new TokenStringRepAndPosition("IDENTIFIER: \"JOE\"", 24), new TokenStringRepAndPosition("CLOSE_PAREN", 27), new TokenStringRepAndPosition("EQUAL", 29), new TokenStringRepAndPosition("DOLLAR", 31), new TokenStringRepAndPosition("OPEN_PAREN", 32), new TokenStringRepAndPosition("IDENTIFIER: \"tiny\"", 33), new TokenStringRepAndPosition("CLOSE_PAREN", 37), new TokenStringRepAndPosition("COMMA", 38), new TokenStringRepAndPosition("DOLLAR", 40), new TokenStringRepAndPosition("OPEN_PAREN", 41), new TokenStringRepAndPosition("IDENTIFIER: \"x\"", 42), new TokenStringRepAndPosition("CLOSE_PAREN", 43), new TokenStringRepAndPosition("GREATER_THAN", 45), new TokenStringRepAndPosition("IDENTIFIER: \"LOG\"", 47), new TokenStringRepAndPosition("OPEN_PAREN", 50), new TokenStringRepAndPosition("FLOAT_CONSTANT: \"1.3E17\"", 51), new TokenStringRepAndPosition("CLOSE_PAREN", 57), new TokenStringRepAndPosition("CLOSE_PAREN", 58), new TokenStringRepAndPosition("CLOSE_PAREN", 59), new TokenStringRepAndPosition("EOS", 60)};
        TokeniserTest.assertEquals(expectedTokens.length, actualTokens.length);
        for (int i = 0; i < expectedTokens.length; ++i) {
            TokeniserTest.assertEquals(expectedTokens[i].getStringRep(), actualTokens[i].getStringRep());
            TokeniserTest.assertEquals(expectedTokens[i].getPosition(), actualTokens[i].getPosition());
        }
    }

    public void testScanner2() throws Exception {
        String tokenAsString;
        Tokeniser tokeniser = new Tokeniser("AND(1.0>=$(BOB),OR($(JOE)=$(tiny),$(x)>LOG(1.3e17)))");
        ArrayList<TokenStringRepAndPosition> tokens = new ArrayList<TokenStringRepAndPosition>();
        do {
            tokenAsString = tokeniser.getTokenAsString();
            int position = tokeniser.getStartPos();
            tokens.add(new TokenStringRepAndPosition(tokenAsString, position));
        } while (tokenAsString != "EOS");
        TokenStringRepAndPosition[] actualTokens = new TokenStringRepAndPosition[tokens.size()];
        tokens.toArray(actualTokens);
        TokenStringRepAndPosition[] expectedTokens = new TokenStringRepAndPosition[]{new TokenStringRepAndPosition("IDENTIFIER: \"AND\"", 0), new TokenStringRepAndPosition("OPEN_PAREN", 3), new TokenStringRepAndPosition("FLOAT_CONSTANT: \"1.0\"", 4), new TokenStringRepAndPosition("GREATER_OR_EQUAL", 7), new TokenStringRepAndPosition("DOLLAR", 9), new TokenStringRepAndPosition("OPEN_PAREN", 10), new TokenStringRepAndPosition("IDENTIFIER: \"BOB\"", 11), new TokenStringRepAndPosition("CLOSE_PAREN", 14), new TokenStringRepAndPosition("COMMA", 15), new TokenStringRepAndPosition("IDENTIFIER: \"OR\"", 16), new TokenStringRepAndPosition("OPEN_PAREN", 18), new TokenStringRepAndPosition("DOLLAR", 19), new TokenStringRepAndPosition("OPEN_PAREN", 20), new TokenStringRepAndPosition("IDENTIFIER: \"JOE\"", 21), new TokenStringRepAndPosition("CLOSE_PAREN", 24), new TokenStringRepAndPosition("EQUAL", 25), new TokenStringRepAndPosition("DOLLAR", 26), new TokenStringRepAndPosition("OPEN_PAREN", 27), new TokenStringRepAndPosition("IDENTIFIER: \"tiny\"", 28), new TokenStringRepAndPosition("CLOSE_PAREN", 32), new TokenStringRepAndPosition("COMMA", 33), new TokenStringRepAndPosition("DOLLAR", 34), new TokenStringRepAndPosition("OPEN_PAREN", 35), new TokenStringRepAndPosition("IDENTIFIER: \"x\"", 36), new TokenStringRepAndPosition("CLOSE_PAREN", 37), new TokenStringRepAndPosition("GREATER_THAN", 38), new TokenStringRepAndPosition("IDENTIFIER: \"LOG\"", 39), new TokenStringRepAndPosition("OPEN_PAREN", 42), new TokenStringRepAndPosition("FLOAT_CONSTANT: \"1.3E17\"", 43), new TokenStringRepAndPosition("CLOSE_PAREN", 49), new TokenStringRepAndPosition("CLOSE_PAREN", 50), new TokenStringRepAndPosition("CLOSE_PAREN", 51), new TokenStringRepAndPosition("EOS", 52)};
        TokeniserTest.assertEquals(expectedTokens.length, actualTokens.length);
        for (int i = 0; i < expectedTokens.length; ++i) {
            TokeniserTest.assertEquals(expectedTokens[i].getStringRep(), actualTokens[i].getStringRep());
            TokeniserTest.assertEquals(expectedTokens[i].getPosition(), actualTokens[i].getPosition());
        }
    }

    public void testScanner3() throws Exception {
        String tokenAsString;
        Tokeniser tokeniser = new Tokeniser("1.79^3");
        ArrayList<TokenStringRepAndPosition> tokens = new ArrayList<TokenStringRepAndPosition>();
        do {
            tokenAsString = tokeniser.getTokenAsString();
            int position = tokeniser.getStartPos();
            tokens.add(new TokenStringRepAndPosition(tokenAsString, position));
        } while (tokenAsString != "EOS");
        TokenStringRepAndPosition[] actualTokens = new TokenStringRepAndPosition[tokens.size()];
        tokens.toArray(actualTokens);
        TokenStringRepAndPosition[] expectedTokens = new TokenStringRepAndPosition[]{new TokenStringRepAndPosition("FLOAT_CONSTANT: \"1.79\"", 0), new TokenStringRepAndPosition("CARET", 4), new TokenStringRepAndPosition("FLOAT_CONSTANT: \"3.0\"", 5), new TokenStringRepAndPosition("EOS", 6)};
        TokeniserTest.assertEquals(expectedTokens.length, actualTokens.length);
        for (int i = 0; i < expectedTokens.length; ++i) {
            TokeniserTest.assertEquals(expectedTokens[i].getStringRep(), actualTokens[i].getStringRep());
            TokeniserTest.assertEquals(expectedTokens[i].getPosition(), actualTokens[i].getPosition());
        }
    }

    public void testScanner4() throws Exception {
        String tokenAsString;
        Tokeniser tokeniser = new Tokeniser("true, fred, FALSE, True");
        ArrayList<TokenStringRepAndPosition> tokens = new ArrayList<TokenStringRepAndPosition>();
        do {
            tokenAsString = tokeniser.getTokenAsString();
            int position = tokeniser.getStartPos();
            tokens.add(new TokenStringRepAndPosition(tokenAsString, position));
        } while (tokenAsString != "EOS");
        TokenStringRepAndPosition[] actualTokens = new TokenStringRepAndPosition[tokens.size()];
        tokens.toArray(actualTokens);
        TokenStringRepAndPosition[] expectedTokens = new TokenStringRepAndPosition[]{new TokenStringRepAndPosition("BOOLEAN_CONSTANT: \"true\"", 0), new TokenStringRepAndPosition("COMMA", 4), new TokenStringRepAndPosition("IDENTIFIER: \"fred\"", 6), new TokenStringRepAndPosition("COMMA", 10), new TokenStringRepAndPosition("BOOLEAN_CONSTANT: \"false\"", 12), new TokenStringRepAndPosition("COMMA", 17), new TokenStringRepAndPosition("BOOLEAN_CONSTANT: \"true\"", 19), new TokenStringRepAndPosition("EOS", 23)};
        TokeniserTest.assertEquals(expectedTokens.length, actualTokens.length);
        for (int i = 0; i < expectedTokens.length; ++i) {
            TokeniserTest.assertEquals(expectedTokens[i].getStringRep(), actualTokens[i].getStringRep());
            TokeniserTest.assertEquals(expectedTokens[i].getPosition(), actualTokens[i].getPosition());
        }
    }

    public void testScanner5() throws Exception {
        String tokenAsString;
        Tokeniser tokeniser = new Tokeniser(".79e2");
        ArrayList<TokenStringRepAndPosition> tokens = new ArrayList<TokenStringRepAndPosition>();
        do {
            tokenAsString = tokeniser.getTokenAsString();
            int position = tokeniser.getStartPos();
            tokens.add(new TokenStringRepAndPosition(tokenAsString, position));
        } while (tokenAsString != "EOS");
        TokenStringRepAndPosition[] actualTokens = new TokenStringRepAndPosition[tokens.size()];
        tokens.toArray(actualTokens);
        TokenStringRepAndPosition[] expectedTokens = new TokenStringRepAndPosition[]{new TokenStringRepAndPosition("FLOAT_CONSTANT: \"79.0\"", 0), new TokenStringRepAndPosition("EOS", 5)};
        TokeniserTest.assertEquals(expectedTokens.length, actualTokens.length);
        for (int i = 0; i < expectedTokens.length; ++i) {
            TokeniserTest.assertEquals(expectedTokens[i].getStringRep(), actualTokens[i].getStringRep());
            TokeniserTest.assertEquals(expectedTokens[i].getPosition(), actualTokens[i].getPosition());
        }
    }

    static class TokenStringRepAndPosition {
        private final String stringRep;
        private final int position;

        TokenStringRepAndPosition(String stringRep, int position) {
            this.stringRep = stringRep;
            this.position = position;
        }

        String getStringRep() {
            return this.stringRep;
        }

        int getPosition() {
            return this.position;
        }
    }
}

