/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.util.border.ShadowBorder;
import jas.util.xml.XMLNodeTraverser;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

class BorderNodeTraverser
extends XMLNodeTraverser {
    private Color color;
    private String type;

    BorderNodeTraverser() {
    }

    void traverse(Node node, JComponent c) throws XMLNodeTraverser.BadXMLException {
        super.traverse(node);
        if (this.type.equals("Bevel In")) {
            c.setBorder(BorderFactory.createLoweredBevelBorder());
        } else if (this.type.equals("Bevel Out")) {
            c.setBorder(BorderFactory.createRaisedBevelBorder());
        } else if (this.type.equals("Etched")) {
            c.setBorder(BorderFactory.createEtchedBorder());
        } else if (this.type.equals("Shadow")) {
            c.setBorder(ShadowBorder.createShadowBorder());
        } else if (this.type.equals("Line")) {
            c.setBorder(BorderFactory.createLineBorder(this.color));
        }
    }

    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("type")) {
            this.type = value;
        } else if (name.equals("color")) {
            this.color = this.toColor(value);
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }
}

