/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.TopoGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSort {
    public static List<TopoGraphNode> sort(Collection<TopoGraphNode> nodes) throws IllegalStateException {
        ArrayList<TopoGraphNode> order = new ArrayList<TopoGraphNode>();
        HashSet<TopoGraphNode> visited = new HashSet<TopoGraphNode>();
        HashSet<TopoGraphNode> alreadySeen = new HashSet<TopoGraphNode>();
        for (TopoGraphNode n : nodes) {
            alreadySeen.clear();
            TopologicalSort.visit(n, alreadySeen, visited, order);
        }
        return order;
    }

    private static void visit(TopoGraphNode n, Set<TopoGraphNode> alreadySeen, Set<TopoGraphNode> visited, List<TopoGraphNode> order) {
        if (alreadySeen.contains(n)) {
            throw new IllegalStateException("cycle containing " + n + " found!");
        }
        alreadySeen.add(n);
        if (!visited.contains(n)) {
            visited.add(n);
            for (TopoGraphNode m : n.getDependents()) {
                TopologicalSort.visit(m, alreadySeen, visited, order);
            }
            order.add(n);
        }
        alreadySeen.remove(n);
    }
}

