/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.UserInfo;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

class JreInstaller {
    private String preferredJre = null;
    private File preferredJreFile;
    private long jreSize = -1L;
    private int jreCount = -1;
    private static final String JRE_DIR = "jre";
    private static final String JRE_TAR = "jre.tar";
    private static final boolean MANUAL_JRE = Boolean.getBoolean("exe4j.manualJre");
    private static final String REGKEY_LOCATED_JVMS = "SOFTWARE\\ej-technologies\\exe4j\\locatedjvms\\";
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private File destinationDirectory = null;
    private boolean sharedInstallation;

    JreInstaller() {
    }

    public void installJre(InstallerContext installerContext, ProgressInterface progressInterface, long l, long l2, long l3) throws IOException, UserCanceledException {
        File file;
        this.updateDestinationDirectory(installerContext.getInstallationDirectory());
        UninstallMode uninstallMode = UninstallMode.IF_CREATED;
        if (this.sharedInstallation) {
            uninstallMode = UninstallMode.NEVER;
        }
        if (InstallerUtil.isWindows()) {
            file = new File(JRE_DIR).getAbsoluteFile();
            if (file.exists()) {
                this.prepareJreDestDir(uninstallMode);
                this.installDir(installerContext, file, this.destinationDirectory, progressInterface, l, l2, l3, uninstallMode);
            }
        } else {
            file = new File(JRE_TAR).getAbsoluteFile();
            if (file.exists()) {
                this.prepareJreDestDir(uninstallMode);
                this.installTar(installerContext, file, this.destinationDirectory, new File(JRE_DIR).getAbsoluteFile(), progressInterface, l, l2, l3, uninstallMode);
            }
        }
        if (!InstallerUtil.isWindows9X() && this.destinationDirectory != null && InstallerConfig.getCurrentInstance().getJreVersion() != null && InstallerConfig.getCurrentInstance().getJreVersion().trim().length() > 2 && InstallerConfig.getCurrentInstance().getJreVersion().trim().substring(0, 3).compareTo("1.5") >= 0 && (file = new File(this.destinationDirectory, "bin/java" + (InstallerUtil.isWindows() ? "w.exe" : ""))).exists()) {
            try {
                Runtime.getRuntime().exec(new String[]{file.getAbsolutePath(), "-Xshare:dump"});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void prepareJreDestDir(UninstallMode uninstallMode) throws IOException {
        if (this.destinationDirectory.exists()) {
            FileUtil.emptyDirectory(this.destinationDirectory);
        }
        FileInstaller.getInstance().createDirectory(this.destinationDirectory, uninstallMode);
        this.addPreferredJreToRegistry(this.destinationDirectory);
    }

    private void addPreferredJreToRegistry(File file) {
        String string;
        if (this.sharedInstallation && InstallerUtil.isWindows() && !Registry.createKey(3, string = REGKEY_LOCATED_JVMS + file.getAbsolutePath().replace('\\', '/') + "/bin/java.exe")) {
            Registry.createKey(2, string);
        }
    }

    private void updateDestinationDirectory(File file) {
        this.destinationDirectory = null;
        if (InstallerConfig.getCurrentInstance().isJreShared()) {
            File file2 = null;
            if (UserInfo.isAdminUser() || InstallerUtil.isWindows()) {
                File file3 = InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() ? FolderInfo.getCommonFilesDirectory() : new File(InstallerUtil.getStandardApplicationsDirectory());
                file3 = new File(file3, "i4j_jres");
                file2 = JreInstaller.getSharedJreSubdir(file3);
            }
            if (file2 != null && InstallerUtil.checkWritable(file2, null, false)) {
                this.sharedInstallation = true;
                this.destinationDirectory = file2;
            } else if (!InstallerUtil.isWindows() && InstallerUtil.checkWritable(file2 = JreInstaller.getSharedJreSubdir(new File(System.getProperty("user.home"), ".i4j_jres")), null, false)) {
                this.sharedInstallation = true;
                this.destinationDirectory = file2;
            }
        }
        if (this.destinationDirectory == null) {
            this.sharedInstallation = false;
            this.destinationDirectory = new File(file, JRE_DIR);
        }
    }

    private static File getSharedJreSubdir(File file) {
        String string = InstallerConfig.getCurrentInstance().getJreVersion().trim();
        if (!string.equals("")) {
            return new File(file, string);
        }
        int n = 1;
        File file2 = new File(file, JRE_DIR + n);
        while (file2.exists()) {
            file2 = new File(file, JRE_DIR + ++n);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long installTar(InstallerContext installerContext, File file, File file2, File file3, ProgressInterface progressInterface, long l, long l2, long l3, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        TarInputStream tarInputStream = new TarInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            TarEntry tarEntry = tarInputStream.getNextEntry();
            while (tarEntry != null) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                boolean bl = false;
                String string = tarEntry.getName();
                if (string.endsWith("jar.pack")) {
                    string = string.substring(0, string.length() - 5);
                    bl = true;
                }
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(string));
                File file4 = new File(file2, string);
                if (tarEntry.isSymlink()) {
                    l3 += l;
                    UnixFileSystem.createLink(tarEntry.getLinkName(), file4);
                    this.fileInstaller.registerUninstallFile(file4);
                } else if (tarEntry.isDirectory()) {
                    l3 += l;
                    this.fileInstaller.createDirectory(file4, uninstallMode);
                } else {
                    long l4 = l3 + l + tarEntry.getSize();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setMode(tarEntry.getMode());
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(tarEntry.getModTime().getTime());
                    if (bl) {
                        this.fileInstaller.install(new File(file3, string), file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)));
                    } else {
                        this.fileInstaller.install(tarInputStream, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)), tarEntry.getSize(), false);
                    }
                    l3 = l4;
                }
                progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
                tarEntry = tarInputStream.getNextEntry();
            }
        }
        finally {
            tarInputStream.close();
        }
        return l3;
    }

    private long installDir(InstallerContext installerContext, File file, File file2, ProgressInterface progressInterface, long l, long l2, long l3, UninstallMode uninstallMode) throws IOException, UserCanceledException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (installerContext.isCancelling()) {
                    throw new UserCanceledException();
                }
                File file3 = fileArray[i];
                progressInterface.setDetailMessage(InstallerUtil.cleanupName(file3.getName()));
                File file4 = new File(file2, file3.getName());
                if (file3.isDirectory()) {
                    this.fileInstaller.createDirectory(file4, uninstallMode);
                    l3 = this.installDir(installerContext, file3, file4, progressInterface, l, l2, l3, uninstallMode);
                    l3 += l;
                } else {
                    long l4 = l3 + l + file3.length();
                    FileOptions fileOptions = new FileOptions();
                    fileOptions.setUninstallMode(uninstallMode);
                    fileOptions.setFileTime(file3.lastModified());
                    this.fileInstaller.install(file3, file4, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)));
                    l3 = l4;
                }
                progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
            }
        }
        return l3;
    }

    public boolean checkJreInstallation(File file) {
        boolean bl;
        if (MANUAL_JRE && this.preferredJre == null) {
            try {
                String string = new File(System.getProperty("java.home")).getCanonicalPath();
                if (!string.startsWith(new File(System.getProperty("user.dir")).getCanonicalPath())) {
                    this.preferredJre = string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        boolean bl2 = bl = InstallerUtil.isWindows() && new File(JRE_DIR).getAbsoluteFile().exists() || !InstallerUtil.isWindows() && new File(JRE_TAR).getAbsoluteFile().exists();
        if (bl) {
            this.updateDestinationDirectory(file);
            if (this.preferredJre == null) {
                this.preferredJre = this.destinationDirectory.getAbsolutePath();
            }
            if (this.sharedInstallation) {
                if (!this.destinationDirectory.exists()) {
                    return true;
                }
                return !new File(this.destinationDirectory, "lib/rt.jar").exists() && !new File(this.destinationDirectory, "jre/lib/rt.jar").exists();
            }
            return true;
        }
        return false;
    }

    public long getJreSize() throws IOException {
        if (this.jreSize == -1L) {
            this.initJreSizeAndCount();
        }
        return this.jreSize;
    }

    private void initJreSizeAndCount() throws IOException {
        if (InstallerUtil.isWindows()) {
            File file = new File(JRE_DIR).getAbsoluteFile();
            this.jreSize = JreInstaller.countSize(file);
            this.jreCount = JreInstaller.countFilesAndDirs(file);
        } else {
            this.jreSize = 0L;
            this.jreCount = 0;
            File file = new File(JRE_TAR).getAbsoluteFile();
            if (file.exists()) {
                TarInputStream tarInputStream = new TarInputStream(new BufferedInputStream(new FileInputStream(file)));
                TarEntry tarEntry = tarInputStream.getNextEntry();
                while (tarEntry != null) {
                    ++this.jreCount;
                    this.jreSize += tarEntry.getSize();
                    tarEntry = tarInputStream.getNextEntry();
                }
            }
        }
    }

    public int getJreCount() throws IOException {
        if (this.jreCount == -1) {
            this.initJreSizeAndCount();
        }
        return this.jreCount;
    }

    private static int countFilesAndDirs(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                ++n;
                if (!file2.isDirectory()) continue;
                n += JreInstaller.countFilesAndDirs(file2);
            }
        }
        return n;
    }

    private static long countSize(File file) {
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    l += JreInstaller.countSize(file2);
                    continue;
                }
                l += file2.length();
            }
        }
        return l;
    }

    public void writePreferredJre(File file) throws UserCanceledException, IOException {
        this.writeOneLineFile(new File(file, "inst_jre.cfg"), System.getProperty("java.home"));
        this.preferredJreFile = new File(file, "pref_jre.cfg");
        if (this.preferredJre != null) {
            this.writeOneLineFile(this.preferredJreFile, this.preferredJre);
        }
    }

    public void setPreferredJre(String string) {
        this.preferredJre = string;
        if (string != null && this.preferredJreFile != null) {
            try {
                this.writeOneLineFile(this.preferredJreFile, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                userCanceledException.printStackTrace();
            }
        }
    }

    private void writeOneLineFile(File file, String string) throws IOException, UserCanceledException {
        this.fileInstaller.createDirectory(file.getParentFile());
        File file2 = File.createTempFile("i4j", null);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
        printWriter.println(string);
        printWriter.close();
        FileInstaller.getInstance().install(file2, file, new FileOptions("644", OverwriteMode.ALWAYS, false));
        file2.delete();
    }
}

