/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class NormDist
extends AbstractFunction {
    public NormDist() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "x", "Argument."), new ArgDescriptor(ArgType.FLOAT, "mean", "The mean of the function."), new ArgDescriptor(ArgType.FLOAT, "stddev", "The standard deviation of the function."), new ArgDescriptor(ArgType.BOOL, "cumulative?", "If true we return the CDF, otherwise we return the pdf.")});
    }

    public String getName() {
        return "NORMDIST";
    }

    public String getFunctionSummary() {
        return "Returns the Normal Probability Density Function or the Cumulative Normal Distribution Function.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double sigma;
        double mu;
        double x;
        try {
            x = FunctionUtil.getArgAsDouble(args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to the 1st argument of NORMDIST()!");
        }
        try {
            mu = FunctionUtil.getArgAsDouble(args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to the 2nd argument of NORMDIST()!");
        }
        try {
            sigma = FunctionUtil.getArgAsDouble(args[2]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[2] + "\" to the 3rd argument of NORMDIST()!");
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("mean parameter in call to NORMDIST must be nonnegative!");
        }
        boolean cumulative = FunctionUtil.getArgAsBoolean(args[3]);
        if (cumulative) {
            double z = (x - mu) / sigma;
            return this.cdf(z);
        }
        return this.pdf(x, mu, sigma);
    }

    private double pdf(double x, double mu, double sigma) {
        double z = (x - mu) / sigma;
        return Math.exp(-0.5 * z * z) / (Math.sqrt(Math.PI * 2) * sigma);
    }

    private double cdf(double z) {
        double cumulativeNorm;
        double zAbs = Math.abs(z);
        if (zAbs > 37.0) {
            cumulativeNorm = 0.0;
        } else {
            double Exponential2 = Math.exp(-zAbs * zAbs / 2.0);
            if (zAbs < 7.07106781186547) {
                double build = 0.0352624965998911 * zAbs + 0.700383064443688;
                build = build * zAbs + 6.37396220353165;
                build = build * zAbs + 33.912866078383;
                build = build * zAbs + 112.079291497871;
                build = build * zAbs + 221.213596169931;
                build = build * zAbs + 220.206867912376;
                cumulativeNorm = Exponential2 * build;
                build = 0.0883883476483184 * zAbs + 1.75566716318264;
                build = build * zAbs + 16.064177579207;
                build = build * zAbs + 86.7807322029461;
                build = build * zAbs + 296.564248779674;
                build = build * zAbs + 637.333633378831;
                build = build * zAbs + 793.826512519948;
                build = build * zAbs + 440.413735824752;
                cumulativeNorm /= build;
            } else {
                double build = zAbs + 0.65;
                build = zAbs + 4.0 / build;
                build = zAbs + 3.0 / build;
                build = zAbs + 2.0 / build;
                build = zAbs + 1.0 / build;
                cumulativeNorm = Exponential2 / build / 2.506628274631;
            }
        }
        if (z > 0.0) {
            cumulativeNorm = 1.0 - cumulativeNorm;
        }
        return cumulativeNorm;
    }
}

