/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.indexdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.AbstractAnnotation;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.CommitFailure;
import org.biojava.utils.Commitable;

class ConfigFile
extends AbstractAnnotation
implements Commitable {
    private File file;
    private Map map;

    public ConfigFile(File file) throws IOException {
        this.file = file;
        this.map = new HashMap();
        if (file.exists()) {
            this.parseFile();
        }
    }

    public void commit() throws CommitFailure {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            throw new CommitFailure("Couldn't commit", e);
        }
    }

    public void rollback() {
        try {
            this.parseFile();
        }
        catch (IOException e) {
            throw new AssertionFailure("Couldn't roll back: your data may be invalid", e);
        }
    }

    private void parseFile() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String line = reader.readLine();
        while (line != null) {
            int tab = line.indexOf("\t");
            String key = line.substring(0, tab).trim();
            String value = line.substring(tab + 1).trim();
            this.map.put(key, value);
            line = reader.readLine();
        }
    }

    private void writeFile() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(this.file));
        writer.println("index\t" + this.map.get("index"));
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            if (me.getKey().equals("index")) continue;
            writer.println(me.getKey() + "\t" + me.getValue());
        }
        writer.flush();
    }

    protected Map getProperties() {
        return this.map;
    }

    protected boolean propertiesAllocated() {
        return true;
    }
}

