/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.immed.nodeshape;

import cytoscape.render.immed.nodeshape.AbstractNodeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class LegacyCustomNodeShape
extends AbstractNodeShape {
    private final GeneralPath path;
    private final AffineTransform xform;
    private final double[] coords;
    private final double[] xformCoords;

    public LegacyCustomNodeShape(double[] coords, byte type) {
        super(type);
        this.coords = coords;
        this.xformCoords = new double[coords.length];
        this.path = new GeneralPath();
        this.xform = new AffineTransform();
    }

    public float[] getCoords() {
        float[] returnThis = new float[this.coords.length];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = (float)this.coords[i];
        }
        return returnThis;
    }

    public Shape getShape(float xMin, float yMin, float xMax, float yMax) {
        double desiredXCenter = (double)(xMin + xMax) / 2.0;
        double desiredYCenter = (double)(yMin + yMax) / 2.0;
        double desiredWidth = xMax - xMin;
        double desiredHeight = yMax - yMin;
        this.xform.setToTranslation(desiredXCenter, desiredYCenter);
        this.xform.scale(desiredWidth, desiredHeight);
        this.xform.transform(this.coords, 0, this.xformCoords, 0, this.coords.length / 2);
        this.path.reset();
        this.path.moveTo((float)this.xformCoords[0], (float)this.xformCoords[1]);
        int i = 2;
        while (i < this.xformCoords.length) {
            this.path.lineTo((float)this.xformCoords[i++], (float)this.xformCoords[i++]);
        }
        this.path.closePath();
        return this.path;
    }
}

