### R code from vignette source 'GOexpress-UsersGuide.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: GOexpress-UsersGuide.Rnw:18-19
###################################################
options(useFancyQuotes="UTF-8")


###################################################
### code chunk number 2: GOexpress-UsersGuide.Rnw:90-92 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("GOexpress")


###################################################
### code chunk number 3: GOexpress-UsersGuide.Rnw:109-110
###################################################
maintainer("GOexpress")


###################################################
### code chunk number 4: GOexpress-UsersGuide.Rnw:134-135
###################################################
citation(package="GOexpress")


###################################################
### code chunk number 5: GOexpress-UsersGuide.Rnw:182-185
###################################################
data(AlvMac) # import the training dataset

library(GOexpress) # load the GOexpress package


###################################################
### code chunk number 6: GOexpress-UsersGuide.Rnw:192-194
###################################################
exprs(AlvMac)[1:5,1:5] # Subset of the expression data
head(pData(AlvMac)) # Subset of the phenotypic information


###################################################
### code chunk number 7: GOexpress-UsersGuide.Rnw:209-210
###################################################
head(rownames(exprs(AlvMac))) # Subset of gene identifiers


###################################################
### code chunk number 8: GOexpress-UsersGuide.Rnw:228-230
###################################################
is.factor(AlvMac$Treatment) # assertion test
AlvMac$Treatment # visual inspection


###################################################
### code chunk number 9: GOexpress-UsersGuide.Rnw:239-240
###################################################
AlvMac$Treatment <- factor(AlvMac$Treatment)


###################################################
### code chunk number 10: GOexpress-UsersGuide.Rnw:248-249
###################################################
AlvMac_results <- GO_analyse(eSet = AlvMac, f = "Treatment")


###################################################
### code chunk number 11: GOexpress-UsersGuide.Rnw:274-275
###################################################
data(microarray2dataset)


###################################################
### code chunk number 12: GOexpress-UsersGuide.Rnw:286-291
###################################################
names(AlvMac_results) # Data slot names
str(AlvMac_results) # Details of data slots
head(AlvMac_results$GO, n=5) # Ranked table of GO terms (subset)
head(AlvMac_results$genes, n=5) # Ranked table of genes (subset)
head(AlvMac_results$mapping) # Gene to gene ontology mapping table (subset)


###################################################
### code chunk number 13: GOexpress-UsersGuide.Rnw:302-308
###################################################
BP <- subset_scores(result = AlvMac_results,
    namespace = "biological_process")
MF <- subset_scores(result = AlvMac_results,
    namespace = "MF") # alias for "molecular_function"
CC <- subset_scores(result = AlvMac_results,
    namespace = "CC") # cellular_component


###################################################
### code chunk number 14: GOexpress-UsersGuide.Rnw:329-338
###################################################
BP.5 <- subset_scores(result = AlvMac_results,
    namespace = "biological_process",
    total = 5) # requires 5 or more associated genes
MF.10 <- subset_scores(result = AlvMac_results,
    namespace = "molecular_function",
    total = 10)
CC.15 <- subset_scores(result = AlvMac_results,
    namespace = "cellular_component",
    total = 15)


###################################################
### code chunk number 15: GOexpress-UsersGuide.Rnw:366-367
###################################################
head(BP.5$GO, n=10)


###################################################
### code chunk number 16: GOexpress-UsersGuide.Rnw:381-383
###################################################
heatmap_GO(go_id = "GO:0034142", result = BP.5, eSet=AlvMac, cexRow=0.4,
    cexCol=1, cex.main=1, main.Lsplit=30)


###################################################
### code chunk number 17: GOexpress-UsersGuide.Rnw:397-399
###################################################
heatmap_GO(go_id = "GO:0034142", result = BP.5, eSet=AlvMac, f="Group",
    cexCol=1, cex.main=1, main.Lsplit=30)


###################################################
### code chunk number 18: GOexpress-UsersGuide.Rnw:409-411
###################################################
cluster_GO(go_id = "GO:0034142", result = BP.5, eSet=AlvMac,
    cex.main=1, cex=0.4, main.Lsplit=30)


###################################################
### code chunk number 19: GOexpress-UsersGuide.Rnw:425-427
###################################################
cluster_GO(go_id = "GO:0034142", result = BP.5, eSet=AlvMac, f = "Time",
    cex.main=1, cex=0.4, main.Lsplit=30)


###################################################
### code chunk number 20: GOexpress-UsersGuide.Rnw:438-439
###################################################
table_genes(go_id = "GO:0034142", result = BP.5)


###################################################
### code chunk number 21: GOexpress-UsersGuide.Rnw:453-454
###################################################
list_genes(go_id = "GO:0034142", result = BP.5)


###################################################
### code chunk number 22: GOexpress-UsersGuide.Rnw:473-476
###################################################
expression_plot(gene_id = "ENSBTAG00000047107", result = BP.5, eSet=AlvMac,
    x_var = "Timepoint", title.size=1.5,
    legend.title.size=10, legend.text.size=10, legend.key.size=15)


###################################################
### code chunk number 23: GOexpress-UsersGuide.Rnw:494-497
###################################################
expression_plot(gene_id = "ENSBTAG00000047107", result = BP.5, eSet=AlvMac,
    x_var = "Animal", title.size=1.5, axis.text.angle=90,
    legend.title.size=10, legend.text.size=10, legend.key.size=15)


###################################################
### code chunk number 24: GOexpress-UsersGuide.Rnw:508-511
###################################################
expression_plot_symbol(gene_symbol = "BIKBA", result = BP.5, eSet=AlvMac,
    x_var = "Timepoint", title.size=1.5,
    legend.title.size=10, legend.text.size=10, legend.key.size=15)


###################################################
### code chunk number 25: GOexpress-UsersGuide.Rnw:544-550
###################################################
AlvMac$Animal.Treatment <- paste(AlvMac$Animal, AlvMac$Treatment, sep="_")
expression_profiles(gene_id = "ENSBTAG00000047107", result = AlvMac_results,
                    eSet=AlvMac, x_var = "Timepoint", line.size=1,
                    seriesF="Animal.Treatment", linetypeF="Animal",
                    legend.title.size=10, legend.text.size=10,
                    legend.key.size=15)


###################################################
### code chunk number 26: GOexpress-UsersGuide.Rnw:564-570
###################################################
expression_profiles(gene_id = "ENSBTAG00000047107", result = AlvMac_results,
                    eSet=AlvMac, x_var = "Timepoint", lty=rep(1,10),
                    # use line-type 1 for all 10 groups
                    seriesF="Animal.Treatment", linetypeF="Animal",
                    legend.title.size=10, legend.text.size=10,
                    legend.key.size=15, line.size=1)


###################################################
### code chunk number 27: GOexpress-UsersGuide.Rnw:579-584
###################################################
expression_profiles_symbol(gene_symbol="TNIP3", result = AlvMac_results,
                    x_var = "Timepoint", linetypeF="Animal", line.size=1,
                    eSet=AlvMac, lty=rep(1,10), seriesF="Animal.Treatment", 
                    title.size=1.5, legend.title.size=10, legend.text.size=10,
                    legend.key.size=15)


###################################################
### code chunk number 28: GOexpress-UsersGuide.Rnw:601-604
###################################################
plot_design(go_id = "GO:0034134", result = BP.5, eSet=AlvMac,
    ask = FALSE, factors = c("Animal", "Treatment", "Time", "Group"),
    main.Lsplit=30)


###################################################
### code chunk number 29: GOexpress-UsersGuide.Rnw:624-625
###################################################
AlvMac$Time <- factor(AlvMac$Time)


###################################################
### code chunk number 30: GOexpress-UsersGuide.Rnw:638-640
###################################################
subEset(eSet=AlvMac, subset=list(Time=c("2H","6H","24H"),
                                    Treatment=c("CN","MB")))


###################################################
### code chunk number 31: GOexpress-UsersGuide.Rnw:659-660
###################################################
overlap_GO(go_ids = head(BP.5$GO$go_id, n=5), result = BP.5, filename=NULL)


###################################################
### code chunk number 32: GOexpress-UsersGuide.Rnw:675-676
###################################################
hist_scores(result = BP.5, labels = TRUE)


###################################################
### code chunk number 33: GOexpress-UsersGuide.Rnw:683-684
###################################################
quantiles_scores(result = BP.5)


###################################################
### code chunk number 34: GOexpress-UsersGuide.Rnw:701-702
###################################################
BP.5.byScore <- rerank(result = BP.5, rank.by = "score")


