### R code from vignette source 'EnrichmentBrowser.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: EnrichmentBrowser.Rnw:39-41
###################################################
library(ALL)
data(ALL)


###################################################
### code chunk number 3: EnrichmentBrowser.Rnw:45-49
###################################################
ind.bs <- grep("^B", ALL$BT)
ind.mut <- which(ALL$mol.biol %in% c("BCR/ABL", "NEG"))
sset <- intersect(ind.bs, ind.mut)
eset <- ALL[, sset]


###################################################
### code chunk number 4: EnrichmentBrowser.Rnw:56-62
###################################################
library(EnrichmentBrowser)
data.dir <- system.file("extdata", package="EnrichmentBrowser")
exprs.file <- file.path(data.dir, "ALL_exprs.tab")
pdat.file <- file.path(data.dir, "ALL_pData.tab")
fdat.file <- file.path(data.dir, "ALL_fData.tab")
eset2 <- read.eset(exprs.file, pdat.file, fdat.file)


###################################################
### code chunk number 5: EnrichmentBrowser.Rnw:101-103
###################################################
exprs(eset)[1:4,1:4]
dim(exprs(eset))


###################################################
### code chunk number 6: EnrichmentBrowser.Rnw:108-111
###################################################
grp <- ifelse(eset$mol.biol == "BCR/ABL", "1", "0")
pData(eset)$GROUP <- grp
table(pData(eset)$GROUP)


###################################################
### code chunk number 7: EnrichmentBrowser.Rnw:120-122
###################################################
eset <- de.ana(eset)
head(fData(eset), n=4)


###################################################
### code chunk number 8: EnrichmentBrowser.Rnw:132-135
###################################################
par(mfrow=c(1,2))
pdistr(eset)
volcano(eset)


###################################################
### code chunk number 9: EnrichmentBrowser.Rnw:141-142
###################################################
fData(eset)[ which.min(fData(eset)$ADJ.PVAL), ]


###################################################
### code chunk number 10: EnrichmentBrowser.Rnw:148-150
###################################################
gene.eset <- probe.2.gene.eset(eset)
head(fData(gene.eset))


###################################################
### code chunk number 11: EnrichmentBrowser.Rnw:156-157
###################################################
head(fData(eset2))


###################################################
### code chunk number 12: EnrichmentBrowser.Rnw:173-178
###################################################
# hsa.gs <- get.kegg.genesets("hsa")
gmt.file <- file.path(data.dir, "hsa_kegg_gs.gmt")
hsa.gs <- parse.genesets.from.GMT(gmt.file)
length(hsa.gs)
hsa.gs[1:2]


###################################################
### code chunk number 13: EnrichmentBrowser.Rnw:182-183
###################################################
sbea.methods()


###################################################
### code chunk number 14: EnrichmentBrowser.Rnw:205-207
###################################################
sbea.res <- sbea(method="ora", eset=gene.eset, gs=hsa.gs, perm=0, alpha=0.05)
gs.ranking(sbea.res)


###################################################
### code chunk number 15: EnrichmentBrowser.Rnw:220-221 (eval = FALSE)
###################################################
## ea.browse(sbea.res)


###################################################
### code chunk number 16: EnrichmentBrowser.Rnw:246-254
###################################################
dummy.sbea <- function(eset, gs, alpha, perm)
{
        sig.ps <- sample(seq(0,0.05, length=1000),5)
        insig.ps <- sample(seq(0.1,1, length=1000), length(gs)-5)
        ps <- sample(c(sig.ps, insig.ps), length(gs))
        names(ps) <- names(gs)
        return(ps)
}


###################################################
### code chunk number 17: EnrichmentBrowser.Rnw:259-261
###################################################
sbea.res2 <- sbea(method="dummy.sbea", eset=gene.eset, gs=hsa.gs)
gs.ranking(sbea.res2)


###################################################
### code chunk number 18: EnrichmentBrowser.Rnw:284-285 (eval = FALSE)
###################################################
## pwys <- download.kegg.pathways("hsa")


###################################################
### code chunk number 19: EnrichmentBrowser.Rnw:291-294
###################################################
pwys <- file.path(data.dir, "hsa_kegg_pwys.zip")
hsa.grn <- compile.grn.from.kegg(pwys)
head(hsa.grn)


###################################################
### code chunk number 20: EnrichmentBrowser.Rnw:299-300
###################################################
nbea.methods()


###################################################
### code chunk number 21: EnrichmentBrowser.Rnw:319-321
###################################################
nbea.res <- nbea(method="ggea", eset=gene.eset, gs=hsa.gs, grn=hsa.grn, perm=100)
gs.ranking(nbea.res)


###################################################
### code chunk number 22: EnrichmentBrowser.Rnw:338-343
###################################################
par(mfrow=c(1,2))
ggea.graph(
    gs=hsa.gs[["hsa05217_Basal_cell_carcinoma"]], 
    grn=hsa.grn, eset=gene.eset)
ggea.graph.legend()


###################################################
### code chunk number 23: EnrichmentBrowser.Rnw:363-365
###################################################
res.list <- list(sbea.res, nbea.res)
comb.res <- comb.ea.results(res.list, pcomb.meth="fisher")


###################################################
### code chunk number 24: EnrichmentBrowser.Rnw:371-372 (eval = FALSE)
###################################################
## ea.browse(comb.res, graph.view=hsa.grn)


###################################################
### code chunk number 25: EnrichmentBrowser.Rnw:393-396 (eval = FALSE)
###################################################
## ebrowser(   meth=c("ora", "ggea"), 
##         exprs=exprs.file, pdat=pdat.file, fdat=fdat.file, 
##         gs=hsa.gs, grn=hsa.grn, comb=TRUE)


