test_footprints <- function() {


	owd <- setwd(tempdir())

	bamfile <- "chrY_3Kb_wgEncodeUwDgfTh1Aln.bam"

	f <- system.file("extdata", bamfile, package="DNaseR",mustWork = TRUE)

	dgf <- footprints(bam=f, chrN="chrY", chrL=3e6, p=1e-9, width=c(6,40), N=2e6)

	#check that the example data outputs a data.frame with 32 rows
	checkEquals(nrow(dgf$footprint.events), 32)

        #check that if minimal input is not introduced the package recognizes an error situation
	#bam
	checkException(footprints(bam=c(), chrN="chrY", chrL=3e6, p=1e-9, width=c(6,40), N=2e6))
	#chrN
	checkException(footprints(bam=f, chrN=c(), chrL=3e6, p=1e-9, width=c(6,40), N=2e6))
	#chrL
	checkException(footprints(bam=f, chrN="chrY", chrL=c(), p=1e-9, width=c(6,40), N=2e6))

	setwd(owd)

}

