## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----package-load,message=FALSE---------------------------------------------------------
library(DEGreport)
data(humanSexDEedgeR)
library(edgeR)

## ----chunk-1----------------------------------------------------------------------------
des<-humanSexDEedgeR$design
fit <- glmFit(humanSexDEedgeR,des)
lrt <- glmLRT(fit)
tab<-cbind(lrt$table,p.adjust(lrt$table$PValue,method="BH"))
detags <- rownames(tab[tab[,5]<=0.1,])
plotSmear(humanSexDEedgeR, de.tags=detags)

## ----chunk-2----------------------------------------------------------------------------
counts<-cpm(humanSexDEedgeR,log=FALSE)
g1<-colnames(counts)[1:41]
g2<-colnames(counts)[42:85]
design<-data.frame(condition=sub("1","Male",sub("0","Female",des[,2])))

## ----chunk-3----------------------------------------------------------------------------
data(geneInfo)

## ----chunk-4----------------------------------------------------------------------------
detag10<-detags[1:10]
pval<-tab[,4]
fc<-tab[detag10,1]

## ----chunk-5, eval=FALSE----------------------------------------------------------------
#  pathreport<-"~/report" #change this to a proper path
#  createReport(g1,g2,counts,detag10,pval,fc,pathreport,colors,pop=400)

## ----chunk-6, eval=FALSE----------------------------------------------------------------
#  degObj(counts,design,"/tmp/degObj.rda")
#  library(shiny)
#  runGist(9930881)

## ----chunk-7----------------------------------------------------------------------------
degMean(pval,counts)
degVar(pval,counts)
degMV(g1,g2,pval,counts)
degMB(detags,g1,g2,counts)
degVB(detags,g1,g2,counts)
rank<-degRank(g1,g2,counts[detag10,],fc,400,500)
degPR(rank)

