### R code from vignette source 'CRISPRseek.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: CRISPRseek.Rnw:130-137
###################################################
library(CRISPRseek)
library(BSgenome.Hsapiens.UCSC.hg19)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(org.Hs.eg.db)
outputDir <- getwd()
inputFilePath <- system.file('extdata', 'inputseq.fa', package = 'CRISPRseek')
REpatternFile <- system.file('extdata', 'NEBenzymes.fa', package = 'CRISPRseek')


###################################################
### code chunk number 3: CRISPRseek.Rnw:164-170
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = TRUE, 
REpatternFile = REpatternFile, findPairedgRNAOnly = TRUE, 
BSgenomeName = Hsapiens, chromToSearch ="chrX", min.gap = 0, max.gap = 20,
txdb = TxDb.Hsapiens.UCSC.hg19.knownGene, orgAnn = org.Hs.egSYMBOL,
max.mismatch = 0,overlap.gRNA.positions = c(17, 18), 
outputDir = outputDir,overwrite = TRUE)


###################################################
### code chunk number 4: CRISPRseek.Rnw:183-189
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = FALSE,
REpatternFile = REpatternFile,findPairedgRNAOnly = TRUE, 
BSgenomeName = Hsapiens, chromToSearch = "chrX",
txdb = TxDb.Hsapiens.UCSC.hg19.knownGene,
orgAnn = org.Hs.egSYMBOL, 
max.mismatch = 1, outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 5: CRISPRseek.Rnw:201-207
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = TRUE,
REpatternFile = REpatternFile, findPairedgRNAOnly = FALSE, 
BSgenomeName = Hsapiens, chromToSearch = "chrX", 
txdb = TxDb.Hsapiens.UCSC.hg19.knownGene,
orgAnn = org.Hs.egSYMBOL,
max.mismatch = 1, outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 6: CRISPRseek.Rnw:220-226
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = FALSE,
REpatternFile = REpatternFile,findPairedgRNAOnly = FALSE, 
BSgenomeName = Hsapiens, chromToSearch = "chrX", 
txdb = TxDb.Hsapiens.UCSC.hg19.knownGene,
orgAnn = org.Hs.egSYMBOL,
max.mismatch = 1, outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 7: CRISPRseek.Rnw:238-247
###################################################
gRNAFilePath <- system.file('extdata', 'testHsap_GATA1_ex2_gRNA1.fa',
package = 'CRISPRseek')
results <- offTargetAnalysis(inputFilePath = gRNAFilePath, 
findgRNAsWithREcutOnly = TRUE, REpatternFile = REpatternFile,
findPairedgRNAOnly = FALSE, findgRNAs = FALSE,
BSgenomeName = Hsapiens, chromToSearch = 'chrX', 
txdb = TxDb.Hsapiens.UCSC.hg19.knownGene, 
orgAnn = org.Hs.egSYMBOL,
max.mismatch = 1, outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 8: CRISPRseek.Rnw:260-263
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = TRUE,
REpatternFile = REpatternFile,findPairedgRNAOnly = TRUE,
chromToSearch = "", outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 9: CRISPRseek.Rnw:275-278
###################################################
results <- offTargetAnalysis(inputFilePath, findgRNAsWithREcutOnly = TRUE,
annotateExon = FALSE,findPairedgRNAOnly = TRUE,
max.mismatch = 0, BSgenomeName = Hsapiens, outputDir = outputDir, overwrite = TRUE)


###################################################
### code chunk number 10: CRISPRseek.Rnw:284-291
###################################################
inputFile1Path <- system.file("extdata", "rs362331C.fa",  package = "CRISPRseek")
inputFile2Path <- system.file("extdata", "rs362331T.fa",  package = "CRISPRseek") 
REpatternFile <- system.file("extdata", "NEBenzymes.fa", package = "CRISPRseek")
seqs <- compare2Sequences(inputFile1Path, inputFile2Path, 
    outputDir = outputDir , REpatternFile = REpatternFile, 
    overwrite = TRUE)
seqs


###################################################
### code chunk number 11: CRISPRseek.Rnw:308-309
###################################################
sessionInfo()


