/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.util.HashSet;
import org.bridgedb.bio.Organism;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrganismTest {
    @Before
    public void setUp() {
    }

    @Test
    public void tasteWine() {
        Organism wine = Organism.VitisVinifera;
        Assert.assertEquals((Object)"Vitis vinifera", (Object)wine.latinName());
        Assert.assertEquals((Object)"Vv", (Object)wine.code());
        Assert.assertEquals((Object)"Wine Grape", (Object)wine.shortName());
    }

    @Test
    public void testFromCode() {
        Organism org = Organism.fromCode("Zm");
        Assert.assertNotNull((Object)((Object)org));
    }

    @Test
    public void testFromCodeNull() {
        Organism org = Organism.fromCode("Null");
        Assert.assertNull((Object)((Object)org));
    }

    @Test
    public void testFromShortName() {
        Organism org = Organism.fromShortName("Frog");
        Assert.assertNotNull((Object)((Object)org));
    }

    @Test
    public void testFromTaxonomyID() {
        Organism org = Organism.fromTaxonomyId(9606);
        Assert.assertNotNull((Object)((Object)org));
        Assert.assertEquals((Object)"Homo sapiens", (Object)org.latinName());
    }

    @Test
    public void testFromNullShortName() {
        Organism org = Organism.fromShortName("Null");
        Assert.assertNull((Object)((Object)org));
    }

    @Test
    public void testCodes() {
        String[] codes = Organism.codes();
        Assert.assertNotNull((Object)codes);
        Assert.assertNotSame((Object)0, (Object)codes.length);
    }

    @Test
    public void testUniqueLatinNames() {
        Organism[] organisms = Organism.values();
        HashSet<String> latinNames = new HashSet<String>();
        for (Organism organism : organisms) {
            latinNames.add(organism.latinName());
        }
        Assert.assertEquals((long)organisms.length, (long)latinNames.size());
    }

    @Test
    public void testUniqueCodes() {
        Organism[] organisms = Organism.values();
        HashSet<String> codes = new HashSet<String>();
        for (Organism organism : organisms) {
            codes.add(organism.code());
        }
        Assert.assertEquals((long)organisms.length, (long)codes.size());
    }

    @Test
    public void tasteHuman() {
        Organism wine = Organism.HomoSapiens;
        Assert.assertEquals((Object)"Homo sapiens", (Object)wine.latinName());
        Assert.assertEquals((Object)"9606", (Object)wine.taxonomyID().getId());
    }
}

