/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import weka.core.FastVector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.FileSourcedConverter;

public abstract class AbstractFileSaver
extends AbstractSaver
implements OptionHandler,
FileSourcedConverter {
    private File m_outputFile;
    private transient BufferedWriter m_writer;
    private String FILE_EXTENSION;
    private String m_prefix;
    private String m_dir;
    protected int m_incrementalCounter;

    public void resetOptions() {
        super.resetOptions();
        this.m_outputFile = null;
        this.m_writer = null;
        this.m_prefix = "";
        this.m_dir = "";
        this.m_incrementalCounter = 0;
    }

    public BufferedWriter getWriter() {
        return this.m_writer;
    }

    public void resetWriter() {
        this.m_writer = null;
    }

    public String getFileExtension() {
        return this.FILE_EXTENSION;
    }

    protected void setFileExtension(String string) {
        this.FILE_EXTENSION = string;
    }

    public File retrieveFile() {
        return this.m_outputFile;
    }

    public void setFile(File file) throws IOException {
        this.m_outputFile = file;
    }

    public void setFilePrefix(String string) {
        this.m_prefix = string;
    }

    public String filePrefix() {
        return this.m_prefix;
    }

    public void setDir(String string) {
        this.m_dir = string;
    }

    public String retrieveDir() {
        return this.m_dir;
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector(2);
        fastVector.addElement(new Option("The input file", "i", 1, "-i <the input file>"));
        fastVector.addElement(new Option("The output file", "o", 1, "-o <the output file>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        File file;
        String string = Utils.getOption('o', stringArray);
        String string2 = Utils.getOption('i', stringArray);
        ArffLoader arffLoader = new ArffLoader();
        this.resetOptions();
        if (string2.length() != 0) {
            try {
                file = new File(string2);
                arffLoader.setFile(file);
                this.setInstances(arffLoader.getDataSet());
            }
            catch (Exception exception) {
                throw new IOException("No data set loaded. Data set has to be in ARFF format.");
            }
        } else {
            throw new IOException("No data set to save.");
        }
        if (string.length() != 0) {
            if (!string.endsWith(this.FILE_EXTENSION)) {
                string = string.lastIndexOf(46) != -1 ? string.substring(0, string.lastIndexOf(46)) + this.FILE_EXTENSION : string + this.FILE_EXTENSION;
            }
            try {
                file = new File(string);
                this.setFile(file);
            }
            catch (Exception exception) {
                throw new IOException("Cannot create output file. Standard out is used.");
            }
            finally {
                this.setDestination(this.m_outputFile);
            }
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.m_outputFile != null) {
            stringArray[n++] = "-o";
            stringArray[n++] = "" + this.m_outputFile;
        } else {
            stringArray[n++] = "-o";
            stringArray[n++] = "";
        }
        if (this.getInstances() != null) {
            stringArray[n++] = "-i";
            stringArray[n++] = "" + this.getInstances().relationName();
        } else {
            stringArray[n++] = "-i";
            stringArray[n++] = "";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            if (this.m_outputFile != null && this.m_outputFile.exists() && this.m_outputFile.delete()) {
                System.out.println("File deleted.");
            }
            this.resetOptions();
        }
    }

    public void setDestination(File file) throws IOException {
        boolean bl = false;
        String string = file.getAbsolutePath();
        if (this.m_outputFile != null) {
            try {
                if (file.exists()) {
                    if (file.delete()) {
                        System.out.println("File exists and will be overridden.");
                    } else {
                        throw new IOException("File already exists.");
                    }
                }
                if (string.lastIndexOf(File.separatorChar) == -1) {
                    bl = file.createNewFile();
                } else {
                    String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                    File file2 = new File(string2);
                    if (file2.exists()) {
                        bl = file.createNewFile();
                    } else {
                        file2.mkdirs();
                        bl = file.createNewFile();
                    }
                }
                if (bl) {
                    this.m_outputFile = file;
                    this.setDestination(new FileOutputStream(this.m_outputFile));
                }
            }
            catch (Exception exception) {
                throw new IOException("Cannot create a new output file. Standard out is used.");
            }
            finally {
                if (!bl) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
            }
        }
    }

    public void setDestination(OutputStream outputStream) throws IOException {
        this.m_writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public void setDirAndPrefix(String string, String string2) {
        try {
            if (this.m_dir.equals("")) {
                this.m_dir = System.getProperty("user.dir");
            }
            if (this.m_prefix.equals("")) {
                this.setFile(new File(this.m_dir + File.separator + string + string2 + this.FILE_EXTENSION));
            } else {
                this.setFile(new File(this.m_dir + File.separator + this.m_prefix + "_" + string + string2 + this.FILE_EXTENSION));
            }
            this.setDestination(this.m_outputFile);
        }
        catch (Exception exception) {
            System.err.println("File prefix and/or directory could not have been set.");
            exception.printStackTrace();
        }
    }

    public abstract String getFileDescription();
}

