### R code from vignette source 'AnnotationHubRecipes.Rnw'

###################################################
### code chunk number 1: exampleInpProcessing
###################################################
makeinparanoid8ToAHMs <- function(currentMetadata){
    baseUrl <- 'http://inparanoid.sbc.su.se/download/current/Orthologs'
    ## Make list of metadata in a helper function
    meta <- .inparanoidMetadataFromUrl(baseUrl)
    ## then make AnnotationHubMetadata objects.
    Map(AnnotationHubMetadata,
        Description=meta$description,
        Genome=meta$genome,
        SourceFile=meta$sourceFile, 
        SourceUrl=meta$sourceUrl,
        SourceVersion=meta$sourceVersion,
        Species=meta$species,
        TaxonomyId=meta$taxonomyId,
        Title=meta$title,
        RDataPath=meta$rDataPath,
        MoreArgs=list(
          Coordinate_1_based = TRUE,
          DataProvider = baseUrl,
          Maintainer = "Marc Carlson <mcarlson@fhcrc.org>",
          RDataClass = "SQLiteFile",
          RDataDateAdded = Sys.time(),
          RDataVersion = "0.0.1",
          Recipe = c("inparanoid8ToDbsRecipe", 
                     package="AnnotationHubData"),
          Tags = c("Inparanoid", "Gene", "Homology", "Annotation")))
}


###################################################
### code chunk number 2: exampleRecipe
###################################################
inparanoid8ToDbsRecipe <- function(ahm){
    require(AnnotationForge)
    inputFiles <- metadata(ahm)$SourceFile
    dbname <- makeInpDb(dir=file.path(inputFiles,""),
                        dataDir=tempdir())
    db <- loadDb(file=dbname)
    outputPath <- file.path(metadata(ahm)$AnnotationHubRoot,
                            metadata(ahm)$RDataPath)
    saveDb(db, file=outputPath) 
    outputFile(ahm)
}


###################################################
### code chunk number 3: makeAnnotationHubResource (eval = FALSE)
###################################################
## makeAnnotationHubResource("Inparanoid8ImportPreparer",
##                           makeinparanoid8ToAHMs)


###################################################
### code chunk number 4: SessionInfo
###################################################
sessionInfo()


