### R code from vignette source 'ALDEx2_vignette.Rnw'

###################################################
### code chunk number 1: ALDEx2_vignette.Rnw:47-49
###################################################
library(ALDEx2)  
data(selex)  


###################################################
### code chunk number 2: ALDEx2_vignette.Rnw:55-56
###################################################
conds <- c(rep("NS", 7), rep("S", 7))  


###################################################
### code chunk number 3: ALDEx2_vignette.Rnw:61-66
###################################################
x <- aldex(selex, conds, mc.samples=16, test="t", effect=TRUE, 
     include.sample.summary=FALSE, verbose=FALSE)

aldex.plot(x, type="MA", test="welch")
aldex.plot(x, type="MW", test="welch")


###################################################
### code chunk number 4: ALDEx2_vignette.Rnw:75-76
###################################################
x <- aldex.clr(selex, mc.samples=16, verbose=TRUE)  


###################################################
### code chunk number 5: ALDEx2_vignette.Rnw:83-84
###################################################
x.tt <- aldex.ttest(x, conds, paired.test=TRUE)  


###################################################
### code chunk number 6: ALDEx2_vignette.Rnw:88-89
###################################################
x.glm <- aldex.glm(x, conds)  


###################################################
### code chunk number 7: ALDEx2_vignette.Rnw:94-95
###################################################
x.effect <- aldex.effect(x, conds, include.sample.summary=FALSE, verbose=TRUE) 


###################################################
### code chunk number 8: ALDEx2_vignette.Rnw:99-100
###################################################
x.all <- data.frame(x.tt, x.glm, x.effect)


###################################################
### code chunk number 9: ALDEx2_vignette.Rnw:116-120
###################################################

par(mfrow=c(1,2))
aldex.plot(x.all, type="MA", test="welch")
aldex.plot(x.all, type="MW", test="welch")


###################################################
### code chunk number 10: ALDEx2_vignette.Rnw:177-195
###################################################

# identify which values are significant in all tests
found.by.all <- which(x.all$we.eBH < 0.05 & 
 x.all$wi.eBH < 0.05 & x.all$glm.eBH < 0.05 & x.all$kw.eBH < 0.05)

# identify which values are significant in fewer than all tests
found.by.one <- which(x.all$we.eBH < 0.05 | 
 x.all$wi.eBH < 0.05 | x.all$glm.eBH < 0.05 | x.all$kw.eBH < 0.05)

# plot the within and between variation of the data
plot(x.all$diff.win, x.all$diff.btw, pch=19, cex=0.3, col=rgb(0,0,0,0.3),
 xlab="Difference within", ylab="Difference betweenn")
points(x.all$diff.win[found.by.one], x.all$diff.btw[found.by.one], pch=19, 
 cex=0.5, col=rgb(0,0,1,0.5))
points(x.all$diff.win[found.by.all], x.all$diff.btw[found.by.all], pch=19, 
 cex=0.5, col=rgb(1,0,0,1))
abline(0,1,lty=2)
abline(0,-1,lty=2)


