/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.bioportal.xmlbeans.SearchBean;
import uk.ac.ebi.ontocat.file.FileOntologyService;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOntologyService
implements OntologyService {
    private static final Logger log = Logger.getLogger(AbstractOntologyService.class);

    @Override
    public Map<String, List<String>> getAnnotations(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyMap();
        }
        return this.getAnnotations(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public List<OntologyTerm> getChildren(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyList();
        }
        return this.getChildren(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public List<String> getDefinitions(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyList();
        }
        return this.getDefinitions(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public List<OntologyTerm> getParents(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyList();
        }
        return this.getParents(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public Map<String, Set<OntologyTerm>> getRelations(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyMap();
        }
        return this.getRelations(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public List<OntologyTerm> getRootTerms(Ontology ontology) throws OntologyServiceException {
        return this.getRootTerms(ontology.getOntologyAccession());
    }

    @Override
    public List<String> getSynonyms(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyList();
        }
        return this.getSynonyms(term.getOntologyAccession(), term.getAccession());
    }

    @Override
    public List<OntologyTerm> getTermPath(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptyList();
        }
        return this.getTermPath(term.getOntologyAccession(), term.getAccession());
    }

    public Set<OntologyTerm> getAllChildren(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptySet();
        }
        return this.processStack(term, new MyFunctor(){

            @Override
            public List<OntologyTerm> call(OntologyTerm term) throws OntologyServiceException {
                return AbstractOntologyService.this.getChildren(term);
            }
        });
    }

    public Set<OntologyTerm> getAllParents(OntologyTerm term) throws OntologyServiceException {
        if (term == null) {
            return Collections.emptySet();
        }
        return this.processStack(term, new MyFunctor(){

            @Override
            public List<OntologyTerm> call(OntologyTerm term) throws OntologyServiceException {
                return AbstractOntologyService.this.getParents(term);
            }
        });
    }

    private Set<OntologyTerm> processStack(OntologyTerm seed, MyFunctor f) throws OntologyServiceException {
        HashSet<OntologyTerm> result = new HashSet<OntologyTerm>();
        Stack<OntologyTerm> stack = new Stack<OntologyTerm>();
        stack.add(seed);
        while (stack.size() != 0) {
            if (result.contains(stack.peek())) {
                stack.pop();
                continue;
            }
            result.add((OntologyTerm)stack.peek());
            stack.addAll(f.call((OntologyTerm)stack.pop()));
        }
        result.remove(seed);
        return result;
    }

    @Override
    public Set<OntologyTerm> getAllChildren(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.getAllChildren(this.getTerm(ontologyAccession, termAccession));
    }

    @Override
    public Set<OntologyTerm> getAllParents(String ontologyAccession, String termAccession) throws OntologyServiceException {
        return this.getAllParents(this.getTerm(ontologyAccession, termAccession));
    }

    @Override
    public Set<OntologyTerm> getAllTerms(String ontologyAccession) throws OntologyServiceException {
        List<OntologyTerm> rootTerms = this.getRootTerms(ontologyAccession);
        HashSet<OntologyTerm> result = new HashSet<OntologyTerm>();
        for (OntologyTerm term : rootTerms) {
            result.addAll(this.getAllChildren(term));
        }
        return result;
    }

    protected List<OntologyTerm> injectTermContext(List<OntologyTerm> list, String query, OntologyService.SearchOptions[] searchOptions) {
        for (OntologyTerm ot : list) {
            String valueMatched = ot instanceof SearchBean ? ((SearchBean)ot).getContents() : ot.getLabel();
            ot.getContext().setSearchOptions(searchOptions);
            ot.getContext().setSimilarityScore(query, valueMatched);
            ot.getContext().setServiceType(this.getServiceType());
        }
        Collections.sort(list);
        return list;
    }

    protected List<OntologyTerm> injectTermContext(Map<OntologyTerm, String> map, String query, OntologyService.SearchOptions[] searchOptions) {
        for (Map.Entry<OntologyTerm, String> entry : map.entrySet()) {
            OntologyTerm ot = entry.getKey();
            String valueMatched = entry.getValue();
            ot.getContext().setSearchOptions(searchOptions);
            ot.getContext().setSimilarityScore(query, valueMatched);
            ot.getContext().setServiceType(this.getServiceType());
        }
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>(map.keySet());
        Collections.sort(result);
        return result;
    }

    private OntologyTerm.OntologyServiceType getServiceType() {
        if (this instanceof OlsOntologyService) {
            return OntologyTerm.OntologyServiceType.OLS;
        }
        if (this instanceof BioportalOntologyService) {
            return OntologyTerm.OntologyServiceType.BIOPORTAL;
        }
        if (this instanceof FileOntologyService) {
            return OntologyTerm.OntologyServiceType.FILE;
        }
        return OntologyTerm.OntologyServiceType.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MyFunctor {
        private MyFunctor() {
        }

        public abstract List<OntologyTerm> call(OntologyTerm var1) throws OntologyServiceException;
    }
}

