### R code from vignette source 'mosaics-example.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
options(prompt = "R> ")


###################################################
### code chunk number 2: mosaics-prelim
###################################################
library("mosaics")


###################################################
### code chunk number 3: constructBins (eval = FALSE)
###################################################
## constructBins( infileLoc="/scratch/eland/", infileName="STAT1_eland_results.txt", 
##     fileFormat="eland_result", outfileLoc=infileLoc, 
##     byChr=FALSE, fragLen=200, binSize=fragLen, capping=0 )


###################################################
### code chunk number 4: mosaicsExample-prelim
###################################################
library(mosaicsExample)


###################################################
### code chunk number 5: ts-readbin
###################################################
exampleBinData <- readBins( type=c("chip","input","M","GC","N"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 6: ts-bindata-show
###################################################
exampleBinData


###################################################
### code chunk number 7: ts-bindata-print
###################################################
print(exampleBinData)[51680:51690,]


###################################################
### code chunk number 8: ts-bindata-plot (eval = FALSE)
###################################################
## plot(exampleBinData)
## plot( exampleBinData, plotType="M" )
## plot( exampleBinData, plotType="GC" )
## plot( exampleBinData, plotType="input" )
## plot( exampleBinData, plotType="M|input" )
## plot( exampleBinData, plotType="GC|input" )  


###################################################
### code chunk number 9: fig-bindata-plot-hist
###################################################
plot(exampleBinData)


###################################################
### code chunk number 10: fig-bindata-plot-M
###################################################
plot( exampleBinData, plotType="M" )


###################################################
### code chunk number 11: fig-bindata-plot-GC
###################################################
plot( exampleBinData, plotType="GC" )


###################################################
### code chunk number 12: fig-bindata-plot-input
###################################################
plot( exampleBinData, plotType="input" )


###################################################
### code chunk number 13: fig-bindata-plot-M-input
###################################################
plot( exampleBinData, plotType="M|input" )


###################################################
### code chunk number 14: fig-bindata-plot-GC-input
###################################################
plot( exampleBinData, plotType="GC|input" )


###################################################
### code chunk number 15: ts-mosaicsfit (eval = FALSE)
###################################################
## exampleFit <- mosaicsFit( exampleBinData, analysisType="TS", bgEst=NA )


###################################################
### code chunk number 16: ts-mosaicsfit-load-fit
###################################################
data(exampleFit)


###################################################
### code chunk number 17: ts-mosaicsfit-show
###################################################
exampleFit


###################################################
### code chunk number 18: ts-mosaicsfit-plot (eval = FALSE)
###################################################
## plot(exampleFit)


###################################################
### code chunk number 19: fig-mosaicsfit-plot
###################################################
plot(exampleFit)


###################################################
### code chunk number 20: ts-mosaicspeak
###################################################
examplePeak <- mosaicsPeak( exampleFit, signalModel="2S", FDR=0.05, 
maxgap=200, minsize=50, thres=10 )


###################################################
### code chunk number 21: ts-mosaicspeak-show
###################################################
examplePeak


###################################################
### code chunk number 22: ts-mosaicspeak-print
###################################################
print(examplePeak)[1:15,]


###################################################
### code chunk number 23: ts-mosaicspeak-export
###################################################
export( examplePeak, type="txt", fileLoc=".", fileName="TSpeakList.txt" )
export( examplePeak, type="bed", fileLoc=".", fileName="TSpeakList.bed" )
export( examplePeak, type="gff", fileLoc=".", fileName="TSpeakList.gff" )


###################################################
### code chunk number 24: io-mosaicsfit (eval = FALSE)
###################################################
## inputOnlyFit <- mosaicsFit( exampleBinData, analysisType="IO" )


###################################################
### code chunk number 25: io-readbin
###################################################
inputOnlyBinData <- readBins( type=c("chip","input"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","input_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 26: io-mosaicsfit-io-readbin (eval = FALSE)
###################################################
## inputOnlyFit <- mosaicsFit( inputOnlyBinData, analysisType="IO" )


###################################################
### code chunk number 27: mosaicsRunAll (eval = FALSE)
###################################################
##      mosaicsRunAll( 
##          chipDir="/scratch/eland/", 
##          chipFileName="STAT1_ChIP_eland_results.txt", 
##          chipFileFormat="eland_result", 
##          controlDir="/scratch/eland/", 
##          controlFileName="STAT1_control_eland_results.txt", 
##          controlFileFormat="eland_result", 
##          binfileDir="/scratch/bin/", 
##          peakDir="/scratch/peak/", 
##          peakFileName="STAT1_peak_list.txt", 
##          peakFileFormat="txt",
##          reportSummary=TRUE, 
##          summaryDir="/scratch/reports/", 
##          summaryFileName="mosaics_summary.txt", 
##          reportExploratory=TRUE, 
##          exploratoryDir="/scratch/reports/", 
##          exploratoryFileName="mosaics_exploratory.pdf", 
##          reportGOF=TRUE, 
##          gofDir="/scratch/reports/", 
##          gofFileName="mosaics_GOF.pdf",
##          byChr=FALSE,
##          FDR=0.05, 
##          fragLen=200, 
##          binSize=fragLen,
##          capping=0,
##          bgEst=NA,
##          signalModel="BIC",
##          parallel=TRUE,
##          nCore=8 )


###################################################
### code chunk number 28: os-readbin
###################################################
OneSampleBinData <- readBins( type=c("chip","M","GC","N"),
    fileName=c( system.file( file.path("extdata","chip_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","M_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","GC_chr21.txt"), package="mosaicsExample"),
    system.file( file.path("extdata","N_chr21.txt"), package="mosaicsExample") ) )


###################################################
### code chunk number 29: os-mosaicsfit (eval = FALSE)
###################################################
## OneSampleFit <- mosaicsFit( OneSampleBinData, analysisType="OS" )


###################################################
### code chunk number 30: os-mosaicspeak (eval = FALSE)
###################################################
## OneSamplePeak <- mosaicsPeak( OneSampleFit, signalModel="2S", FDR=0.05,
## maxgap=200, minsize=50, thres=10 )


