### R code from vignette source 'GlobalTest_deprecated.Rnw'

###################################################
### code chunk number 1: library
###################################################
library(globaltest)


###################################################
### code chunk number 2: deprecated
###################################################
gt.options(warn.deprecated=FALSE)


###################################################
### code chunk number 3: options
###################################################
options(continue = "  ")


###################################################
### code chunk number 4: getGolubData
###################################################
library(golubEsets)
library(vsn)
data(Golub_Merge)
Golub<-Golub_Merge[,1:34]
exprs(Golub)<-exprs(vsn2(Golub_Merge[,1:34]))


###################################################
### code chunk number 5: getNKIData
###################################################
library(globaltest)
data(vandeVijver)


###################################################
### code chunk number 6: loadKEGGandGO
###################################################
library(hu6800.db)
kegg <- as.list(hu6800PATH2PROBE)
go <- as.list(hu6800GO2ALLPROBES)


###################################################
### code chunk number 7: cleanGO
###################################################
go <- lapply(go, function(x) x[!is.na(names(x)) & (names(x) != "IEA")])


###################################################
### code chunk number 8: makeCellcycle
###################################################
GO.cellcycle <- go[["GO:0007049"]]
KEGG.cellcycle <- kegg[["04110"]]


###################################################
### code chunk number 9: all
###################################################
gt.all <- globaltest(Golub, "ALL.AML")


###################################################
### code chunk number 10: all.display
###################################################
gt.all


###################################################
### code chunk number 11: cellcycle
###################################################
globaltest(Golub, "ALL.AML", GO.cellcycle)


###################################################
### code chunk number 12: twocellcycle
###################################################
cellcycle <- list(go = GO.cellcycle, kegg = KEGG.cellcycle)
globaltest(Golub, "ALL.AML", cellcycle)


###################################################
### code chunk number 13: kegg
###################################################
gt.kegg <- globaltest(Golub, "ALL.AML", kegg)


###################################################
### code chunk number 14: kegg.display (eval = FALSE)
###################################################
## gt.kegg["04110"]
## gt.kegg[1:10]


###################################################
### code chunk number 15: sort.by.p
###################################################
sorted <- sort(gt.kegg)
top5 <- sorted[1:5]
top5


###################################################
### code chunk number 16: kegg.numbers.to.names
###################################################
library(KEGG.db)
names(top5) <- as.list(KEGGPATHID2NAME)[names(top5)]
top5


###################################################
### code chunk number 17: useful
###################################################
p.value(top5)
names(top5)
result(top5)
length(top5)


###################################################
### code chunk number 18: multtest
###################################################
sorted <- gt.multtest(sorted, "FWER")
sorted[1:5]


###################################################
### code chunk number 19: golub_Source
###################################################
globaltest(Golub, "Source")


###################################################
### code chunk number 20: golub_Source_2levels
###################################################
globaltest(Golub, "Source", levels = c("CALGB", "CCG"))


###################################################
### code chunk number 21: golub_Source_1level
###################################################
globaltest(Golub, "Source", levels = "St-Jude")


###################################################
### code chunk number 22: golub_Source_factor (eval = FALSE)
###################################################
## globaltest(Golub, "factor(Source)")


###################################################
### code chunk number 23: golub_pctBlasts
###################################################
calgb <- pData(Golub)["Source"] == "CALGB"
globaltest(Golub[,calgb], "pctBlasts")


###################################################
### code chunk number 24: vandeVijver_survival
###################################################
library(survival)
globaltest(vandeVijver, "Surv(TIMEsurvival, EVENTdeath)")


###################################################
### code chunk number 25: vandeVijver_survival_alternatives (eval = FALSE)
###################################################
## globaltest(vandeVijver, "Surv(TIMEsurvival, EVENTdeath == 1)")
## globaltest(vandeVijver, "TIMEsurvival", d = "EVENTdeath")
## globaltest(vandeVijver, "TIMEsurvival", d = "EVENTdeath", event = 1)


###################################################
### code chunk number 26: method
###################################################
globaltest(Golub, "ALL.AML", GO.cellcycle, method = "p", nperm = 1000)


###################################################
### code chunk number 27: permutations
###################################################
gt <- globaltest(Golub, "ALL.AML", GO.cellcycle)
permutations(gt, nperm = 2000)


###################################################
### code chunk number 28: golub_adjust_BM.PB
###################################################
globaltest(Golub, ALL.AML ~ BM.PB, GO.cellcycle)


###################################################
### code chunk number 29: vijver_adjust_all
###################################################
globaltest(vandeVijver, Surv(TIMEsurvival, EVENTdeath) ~ NIH + ESR1 + Posnodes)


###################################################
### code chunk number 30: vijver_esr1
###################################################
globaltest(vandeVijver, "ESR1")


###################################################
### code chunk number 31: golub_adjust_AML.ALL
###################################################
gt <- globaltest(vandeVijver, Surv(TIMEsurvival, EVENTdeath) ~ ESR1)
fit(gt)


###################################################
### code chunk number 32: sampling
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle)
sampled.gt <- sampling(gt)
sampled.gt


###################################################
### code chunk number 33: hist (eval = FALSE)
###################################################
## gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle, method = "p")
## hist(gt)


###################################################
### code chunk number 34: hist-plot
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle, method = "p")
hist(gt)


###################################################
### code chunk number 35: geneplot
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
geneplot(gt, "00561")


###################################################
### code chunk number 36: geneplot_store
###################################################
myplot <- geneplot(gt, "00561", plot = FALSE)


###################################################
### code chunk number 37: geneplot_changenames
###################################################
names(myplot) <- as.list(hu6800SYMBOL)[names(myplot)]
plot(myplot)


###################################################
### code chunk number 38: geneplot_changenames2
###################################################
plot(myplot)


###################################################
### code chunk number 39: geneplot_sort
###################################################
mysorted <- sort(myplot)
top5 <- mysorted[1:5]


###################################################
### code chunk number 40: geneplot_utilities
###################################################
z.score(top5)
names(top5)
result(top5)
length(top5)


###################################################
### code chunk number 41: sampleplot
###################################################
gt <- globaltest(Golub, "ALL.AML", KEGG.cellcycle)
sampleplot(gt)


###################################################
### code chunk number 42: sampleplot-plot
###################################################
sampleplot(gt)


###################################################
### code chunk number 43: checkerboard
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
checkerboard(gt.kegg, "04110")


###################################################
### code chunk number 44: checkerboard-plot
###################################################
checkerboard(gt, "04110")


###################################################
### code chunk number 45: regressionplot
###################################################
gt <- globaltest(Golub, "ALL.AML", kegg)
regressionplot(gt, "04110", sampleid = "39")


###################################################
### code chunk number 46: regressionplot2
###################################################
regressionplot(gt, "04110", sampleid = c("39","40"))


###################################################
### code chunk number 47: regressionplot-plot
###################################################
regressionplot(gt, "04110", "39")


###################################################
### code chunk number 48: GlobalTest_deprecated.Rnw:999-1000
###################################################
toLatex(sessionInfo())


