### R code from vignette source 'clusterProfiler.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)
require(clusterProfiler)


###################################################
### code chunk number 2: gcSample
###################################################
require(clusterProfiler)
data(gcSample)
gcSample


###################################################
### code chunk number 3: groupGO
###################################################
x <- groupGO(gene=gcSample[[1]], organism="human", ont="CC", level=2, readable=TRUE)
summary(x)


###################################################
### code chunk number 4: enrichGO (eval = FALSE)
###################################################
## y <- enrichGO(gene=gcSample[[2]], organism="human", ont="MF", pvalueCutoff=0.01, readable=TRUE)


###################################################
### code chunk number 5: enrichKEGG
###################################################
z <- enrichKEGG(gene=gcSample[[3]], organism="human", pvalueCutoff=0.05, readable=TRUE)
summary(z)


###################################################
### code chunk number 6: groupGO (eval = FALSE)
###################################################
## plot(x, title="CC Ontology Classification, level 2", font.size=12)


###################################################
### code chunk number 7: enrichKEGG (eval = FALSE)
###################################################
## plot(z, title="KEGG Enrichment")


###################################################
### code chunk number 8: compareCluster (eval = FALSE)
###################################################
## xx <- compareCluster(gcSample, fun=groupGO, organism="human", ont="MF", level=2)
## plot(xx, title="MF Ontology Distribution Comparison")


###################################################
### code chunk number 9: compareCluster (eval = FALSE)
###################################################
## yy <- compareCluster(gcSample, fun=enrichGO, organism="human", ont="CC", pvalueCutoff=0.01)
## plot(yy, title="CC Ontology Enrichment Comparison")


###################################################
### code chunk number 10: compareCluster (eval = FALSE)
###################################################
## plot(yy, title="CC Ontology Enrichment Comparison", type="bar", by="count")


###################################################
### code chunk number 11: compareCluster-KEGG (eval = FALSE)
###################################################
## zz <- compareCluster(gcSample, fun=enrichKEGG, organism="human", pvalueCutoff=0.05)
## plot(zz, title="KEGG Pathway Enrichment Comparison")


###################################################
### code chunk number 12: compareCluster-DO (eval = FALSE)
###################################################
## require(DOSE)
## do <- compareCluster(gcSample, fun=enrichDO, organism="human", pvalueCutoff=0.05)
## plot(do, title="Disease Ontology Enrichment Comparison")


###################################################
### code chunk number 13: clusterProfiler.Rnw:224-225
###################################################
sessionInfo()


