### R code from vignette source 'charm.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(width=60)
options(continue=" ")
options(prompt="R> ")


###################################################
### code chunk number 2: loadCharm
###################################################
library(charm)
library(charmData)


###################################################
### code chunk number 3: dataDir
###################################################
dataDir <- system.file("data", package="charmData")
dataDir


###################################################
### code chunk number 4: phenodata
###################################################
phenodataDir <- system.file("extdata", package="charmData")
pd <- read.delim(file.path(phenodataDir, "phenodata.txt"))
phenodataDir
pd


###################################################
### code chunk number 5: validatePd
###################################################
res <- validatePd(pd)


###################################################
### code chunk number 6: readData
###################################################
rawData <- readCharm(files=pd$filename, path=dataDir, sampleKey=pd)
rawData


###################################################
### code chunk number 7: qc
###################################################
qual <- qcReport(rawData, file="qcReport.pdf")
qual


###################################################
### code chunk number 8: getControlIndex
###################################################
library(BSgenome.Hsapiens.UCSC.hg18)
ctrlIdx <- getControlIndex(rawData, subject=Hsapiens)


###################################################
### code chunk number 9: methp_density
###################################################
grp <- pData(rawData)$tissue
p <- methp(rawData, controlIndex=ctrlIdx, 
	plotDensity="density.pdf", plotDensityGroups=grp) 
head(p)


###################################################
### code chunk number 10: dmrFinder
###################################################
dmr <- dmrFinder(rawData, p=p, groups=grp, 
	compare=c("colon", "liver",
	  		  "colon", "spleen"))


###################################################
### code chunk number 11: headDmr
###################################################
names(dmr)
names(dmr$tabs)
head(dmr$tabs[[1]])


###################################################
### code chunk number 12: charm.Rnw:168-169
###################################################
sessionInfo()


