### R code from vignette source 'HOWTO-BCV.Rnw'

###################################################
### code chunk number 1: HOWTO-BCV.Rnw:43-45
###################################################
library("biocViews")
library("Biobase")


###################################################
### code chunk number 2: VocabDefinition
###################################################
vocabFile <- system.file("dot/biocViewsVocab.dot", package="biocViews")
cat(readLines(vocabFile)[1:20], sep="\n")
cat("...\n")


###################################################
### code chunk number 3: getViews
###################################################
data(biocViewsVocab)
reposPath <- system.file("doc", package="biocViews")
reposUrl <- paste("file://", reposPath, sep="")
biocViews <- getBiocSubViews(reposUrl, biocViewsVocab, topTerm="Software")

print(biocViews[1:2])



###################################################
### code chunk number 4: listTerms
###################################################
getSubTerms(biocViewsVocab, term="AssayTechnologies")


###################################################
### code chunk number 5: htmlViewsGen
###################################################
viewsDir <- file.path(tempdir(), "biocViews")
dir.create(viewsDir)
writeBiocViews(biocViews, dir=viewsDir)

dir(viewsDir)[1:2]


