/*
 * Decompiled with CFR 0.152.
 */
package org.renci.sequencing.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.renci.sequencing.util.SortedBaseHolder;

public class BAMRecalibrator
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BAM file to process")
    public File INPUT;
    @Option(doc="The name of the BAM output file.")
    public File BAM_OUTPUT;
    @Option(doc="The name of the coefficients text file.")
    public File COEFF;
    @Option(doc="The name of the flagged positions file.")
    public File FLAGGED;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = true;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = true;
    @Option(doc="If set to true, include quality for no-call bases in the distribution")
    public boolean INCLUDE_NO_CALLS = true;
    @Option(shortName="S", doc="If set to true, adjust the phred scale by 33")
    public boolean AUTO_PHRED_SCALE = true;
    @Option(doc="Stop after processing N reads. Mostly for debugging purposes.")
    public int STOP_AFTER = 0;
    @Option(doc="Region to unpack of the form 1:1-2500000 'chromosome:startpos-endpos'", optional=true)
    public String REGION = null;
    @Option(doc="If set to true, display available chromome sequence names and sequence lengths for the input BAM file.", mutex={"BAM_OUTPUT", "COEFF", "FLAGGED"})
    public boolean TARGETS = false;
    @Option(doc="Debug mode")
    public boolean DEBUG = false;
    @Option(doc="ignore")
    public boolean IGNORE_WARNINGS = true;
    private boolean bHasRegion = false;
    private int iStartPos;
    private int iEndPos;
    private String sChromosome;
    private Set<String> tSetOfBadBases;
    private static SAMFileWriter outputSam;

    public BAMRecalibrator() {
        this.QUIET = true;
    }

    public static void main(String[] args) {
        try {
            if (BAMRecalibrator.runIt(args) != 0) {
                System.out.println("Exiting with an error and a non-zero status.");
                throw new Exception("Exiting with an error and a non-zero status");
            }
        }
        catch (RuntimeException rte) {
            outputSam.close();
            rte.printStackTrace();
            BAMRecalibrator.doRuntimeExceptionCIGARErrorAndExit(rte);
        }
        catch (Exception e) {
            System.err.println("Caught an exception : " + e.getMessage());
            e.printStackTrace();
            outputSam.close();
        }
    }

    private static int runIt(String[] args) {
        int iReturn = new BAMRecalibrator().instanceMain(args);
        if (iReturn == 0) {
            System.out.println("[" + new Date() + "] " + "org.renci.sequencing.util.BAMRecalibrator done");
            System.out.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
        }
        return iReturn;
    }

    public static void doRuntimeExceptionCIGARErrorAndExit(Exception tException) {
        if (tException.getMessage().contains("CIGAR")) {
            System.out.println("hey hey hey ###");
        } else if (tException.getMessage().contains("SAM validation error")) {
            tException.printStackTrace();
            System.err.println("CIGAR should have zero elements for unmapped string.  Maybe aligned using BWA?  Exiting recalibration.");
        } else {
            tException.printStackTrace();
            System.err.println("Caught a RuntimeException: " + tException.getMessage());
        }
    }

    @Override
    protected int doWork() {
        try {
            this.tSetOfBadBases = this.makeBadBaseSet();
            SAMFileReader tSAMFileReaderIn = new SAMFileReader(this.INPUT);
            Object in2 = null;
            tSAMFileReaderIn.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            if (this.TARGETS) {
                this.handleTargets(tSAMFileReaderIn);
            }
            IoUtil.assertFileIsReadable(this.INPUT);
            List<Float> tCoeffList = this.loadCoeffArrayFromFile(this.COEFF);
            List<Integer> tFlaggedList = this.loadFlaggedArrayFromFile(this.FLAGGED);
            SAMFileHeader tHeader = new SAMFileHeader();
            outputSam = new SAMFileWriterFactory().makeBAMWriter(tSAMFileReaderIn.getFileHeader(), true, this.BAM_OUTPUT);
            if (this.REGION != null) {
                this.handleRegionParameters();
            }
            if (!tSAMFileReaderIn.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
                System.out.println("WARNING: This BAM's header does not say it is sorted (perhaps it was sorted by samtools?)");
            }
            SortedBaseHolder sbh = new SortedBaseHolder(tCoeffList, tFlaggedList, this.tSetOfBadBases, this.AUTO_PHRED_SCALE);
            if (this.AUTO_PHRED_SCALE && sbh.needsPhredScaling(tSAMFileReaderIn)) {
                sbh.setPhredScaling(true);
            } else {
                sbh.setPhredScaling(false);
            }
            tSAMFileReaderIn.close();
            tSAMFileReaderIn = new SAMFileReader(this.INPUT);
            if (this.bHasRegion) {
                if (tSAMFileReaderIn == null || outputSam == null || sbh == null) {
                    System.out.println("SAMFileReader is null or SAMOutputWriter is null or SortedBaseHolder is null.");
                }
                this.processRegionQuery(tSAMFileReaderIn, outputSam, sbh);
            } else {
                int processed = 0;
                for (SAMRecord rec : tSAMFileReaderIn) {
                    if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) continue;
                    sbh.addRead(rec, outputSam, tHeader);
                    if (this.STOP_AFTER > 0 && ++processed > this.STOP_AFTER) break;
                }
                outputSam.close();
            }
        }
        catch (IOException e) {
            System.out.println("I/O Error.  Underlying cause:\n " + e.getMessage());
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            BAMRecalibrator.doRuntimeExceptionCIGARErrorAndExit(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void printAttribute(SAMFileReader tSAMFileReader, String sAttributeIn) {
        tSAMFileReader = new SAMFileReader(this.BAM_OUTPUT);
        SAMRecordIterator tI2 = tSAMFileReader.iterator();
        int iCounter = 0;
        while (tI2.hasNext()) {
            ++iCounter;
            SAMRecord tRec = (SAMRecord)tI2.next();
            System.out.println("tRec.getAttribute(Q2): " + tRec.getAttribute("Q2"));
            System.out.println("tRec.getReadString() " + tRec.getReadString());
            System.out.println();
        }
    }

    public Set<String> makeBadBaseSet() {
        HashSet<String> tBadBaseSet = new HashSet<String>();
        tBadBaseSet.clear();
        tBadBaseSet.add("M");
        tBadBaseSet.add("R");
        tBadBaseSet.add("S");
        tBadBaseSet.add("V");
        tBadBaseSet.add("W");
        tBadBaseSet.add("Y");
        tBadBaseSet.add("H");
        tBadBaseSet.add("K");
        tBadBaseSet.add("D");
        tBadBaseSet.add("B");
        tBadBaseSet.add("N");
        return tBadBaseSet;
    }

    private void handleTargets(SAMFileReader tSAMFileReaderIn) {
        SAMFileHeader tHeader = tSAMFileReaderIn.getFileHeader();
        SAMSequenceDictionary tDict = tHeader.getSequenceDictionary();
        List<SAMSequenceRecord> tSRecordList = tDict.getSequences();
        Iterator<SAMSequenceRecord> tIter3 = tSRecordList.iterator();
        System.out.println("Sequence Name:\t Sequence Length");
        while (tIter3.hasNext()) {
            SAMSequenceRecord tSSRecord = tIter3.next();
            System.out.println(String.valueOf(tSSRecord.getSequenceName()) + ":\t " + tSSRecord.getSequenceLength());
        }
    }

    private void handleRegionParameters() throws Exception {
        try {
            String[] sRegionArray = this.REGION.split(":");
            if (sRegionArray.length != 2) {
                System.out.println("REGION parameter is not of the form 1:1-2500000 where '1' is the chromosome, '1-2500000' is the start and end position.");
                throw new Exception("REGION parameter is not of the form 1:1-2500000 where '1' is the chromosome, '1-2500000' is the start and end position.");
            }
            this.sChromosome = sRegionArray[0];
            String[] sPositionArray = sRegionArray[1].split("-");
            if (sPositionArray.length != 2) {
                System.out.println("REGION parameter does not include a start and end position.");
                throw new Exception("REGION parameter does not include a start and end position.");
            }
            this.iStartPos = Integer.parseInt(sPositionArray[0]);
            this.iEndPos = Integer.parseInt(sPositionArray[1]);
            this.bHasRegion = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void processRegionQuery(SAMFileReader tSAMFileReaderIn, SAMFileWriter outputSam, SortedBaseHolder sbh) throws Exception {
        try {
            int processed = 0;
            SAMRecordIterator tSRIter = tSAMFileReaderIn.query(this.sChromosome, this.iStartPos, this.iEndPos, false);
            SAMFileHeader tHeader = new SAMFileHeader();
            while (tSRIter.hasNext()) {
                SAMRecord tRecord = (SAMRecord)tSRIter.next();
                if (this.PF_READS_ONLY && tRecord.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && tRecord.getReadUnmappedFlag()) continue;
                if (tRecord == null || outputSam == null || sbh == null) {
                    System.out.println("null too");
                }
                sbh.addRead(tRecord, outputSam, tHeader);
                if (this.STOP_AFTER > 0 && ++processed > this.STOP_AFTER) break;
            }
            outputSam.close();
            tSAMFileReaderIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Integer> loadFlaggedArrayFromFile(File tFileIn) {
        ArrayList<Integer> tList = new ArrayList<Integer>();
        try {
            FileReader tInStream = new FileReader(tFileIn);
            BufferedReader tBInStream = new BufferedReader(tInStream);
            String sLine = null;
            while ((sLine = tBInStream.readLine()) != null) {
                tList.add(Integer.valueOf(sLine));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tList;
    }

    private List<Float> loadCoeffArrayFromFile(File tFileIn) {
        ArrayList<Float> tList = new ArrayList<Float>();
        try {
            FileReader tInStream = new FileReader(tFileIn);
            BufferedReader tBInStream = new BufferedReader(tInStream);
            String sLine = null;
            while ((sLine = tBInStream.readLine()) != null) {
                tList.add(Float.valueOf(sLine));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tList;
    }
}

