### R code from vignette source 'RTools4TB.Rnw'

###################################################
### code chunk number 1: RTools4TB.Rnw:51-53
###################################################
library(RTools4TB)
args(getSignatures)


###################################################
### code chunk number 2: RTools4TB.Rnw:58-60 (eval = FALSE)
###################################################
## res <- getSignatures(field="gene", value="PCNA")
## head(res)


###################################################
### code chunk number 3: RTools4TB.Rnw:66-67
###################################################
res <- getSignatures(field="experiment", value="GSE2004")


###################################################
### code chunk number 4: RTools4TB.Rnw:72-73
###################################################
res <- getSignatures(field="platform", value="GPL96")


###################################################
### code chunk number 5: RTools4TB.Rnw:78-83
###################################################
data(annotationList)
names(annotationList)
attach(annotationList)
annotationList[1:4,]
table(TableName)


###################################################
### code chunk number 6: RTools4TB.Rnw:88-90
###################################################
#Signatures containing genes related to Cell-Cycle
cc <- getSignatures(field="annotation", value="HSA04110:CELL CYCLE", qValue=20)


###################################################
### code chunk number 7: RTools4TB.Rnw:95-98
###################################################
query <- paste(grep("^8q", Keyword,val=T),collapse="|")
query
cc <- getSignatures(field="annotation", value=query, qValue=10)


###################################################
### code chunk number 8: RTools4TB.Rnw:109-111
###################################################
gl <- getSignatures(field="gene", value="CD3D CD3E CD4", nbMin=2)
head(gl)


###################################################
### code chunk number 9: RTools4TB.Rnw:127-128
###################################################
res <- getSignatures(field="gene", value="CD4")


###################################################
### code chunk number 10: RTools4TB.Rnw:134-135
###################################################
res <- getSignatures(field="gene", value="CD4 & CD3E & !CD14")


###################################################
### code chunk number 11: RTools4TB.Rnw:142-143
###################################################
res <- getSignatures(field="gene", value="CD4 & CD3E & !(CD19 | IGHM)")


###################################################
### code chunk number 12: RTools4TB.Rnw:153-158
###################################################
TS <- getSignatures(field="gene", value="XBP1 & ESR1 & GATA3")
head(TS)
a <- getTBInfo(field="signature", value="3DE64836D", verbose=FALSE)
exp <- a["Experiment",1]
info <- getTBInfo(field="experiment", value=exp, verbose=TRUE)


###################################################
### code chunk number 13: RTools4TB.Rnw:169-170
###################################################
library(biocGraph)


###################################################
### code chunk number 14: RTools4TB.Rnw:173-174 (eval = FALSE)
###################################################
## adjMat <- createGraph4BioC(request="XBP1 & ESR1 & GATA3", prop=80)


###################################################
### code chunk number 15: RTools4TB.Rnw:176-177
###################################################
adjMat <- as.matrix(read.table("ftp://tagc.univ-mrs.fr/public/TranscriptomeBrowser/RTools4TB/adjMat.txt", sep="\t", quote="", head=TRUE, row=1))


###################################################
### code chunk number 16: graph
###################################################
g1 <- new("graphAM", adjMat=adjMat)
nodes(g1)
nAt <- makeNodeAttrs(g1)
nAt$fillcolor[match(rownames(as.matrix(nAt$fillcolor)), c("GATA3", "XBP1", "ESR1"), nomatch=F)!=0] <- "green"
nAt$fillcolor[match(rownames(as.matrix(nAt$fillcolor)), c("TBC1D9", "FOXA1"), nomatch=F)!=0] <- "yellow"
plot(g1,"fdp",nodeAttrs=nAt)


###################################################
### code chunk number 17: RTools4TB.Rnw:204-207
###################################################
a <- getTBInfo(field="signature", value="3DE64836D", verbose=FALSE)
exp <- a["Experiment",1]
info <- getTBInfo(field="experiment", value=exp, verbose=TRUE)


###################################################
### code chunk number 18: RTools4TB.Rnw:211-213
###################################################
sampleInfo <- getTBInfo(field="samples", value = "3DE64836D")
head(sampleInfo[,1:2])


###################################################
### code chunk number 19: RTools4TB.Rnw:219-221
###################################################
em <- getExpressionMatrix(signatureID="3DE64836D")
class(em)


###################################################
### code chunk number 20: RTools4TB.Rnw:226-227
###################################################
pdf(file="heat.pdf")


###################################################
### code chunk number 21: RTools4TB.Rnw:230-249
###################################################
library(RColorBrewer)
col <- colorRampPalette(brewer.pal(10, "RdBu"))(256)
geneNames <- paste(em[,1],em[,2],sep="||")
em <- as.matrix(em[,-c(1,2)])
ind <- match(colnames(em), sampleInfo[,1])
colnames(em) <- sampleInfo[ind,2]
row <- rep(1,nrow(em))
ind <- grep("(XBP1)|(ESR1)|(GATA3)", geneNames,perl=TRUE)
row[ind] <- 2
rc <- rainbow(2, start=0, end=.3)
rc <- rc[row]
col <- colorRampPalette(brewer.pal(10, "RdBu"))(256)
split <- strsplit(colnames(em)," (", fixed=TRUE)
pheno <- unlist(lapply(split,"[",1))
pheno <- as.factor(pheno)
levels(pheno) <- 1:5
cc <- rainbow(5, start=0, end=.3)
cc <- cc[pheno]
heatmap(em, col=col, RowSideColors=rc, ColSideColors=cc, labRow=geneNames, cexRow=0.3)


###################################################
### code chunk number 22: RTools4TB.Rnw:252-253
###################################################
dev.off()


###################################################
### code chunk number 23: profil
###################################################
  plotGeneExpProfiles(data=em, X11=FALSE)


###################################################
### code chunk number 24: RTools4TB.Rnw:304-307 (eval = FALSE)
###################################################
## library(ALL)
## data(ALL)
## sub <- exprs(ALL)[1:3000,]


###################################################
### code chunk number 25: RTools4TB.Rnw:312-313 (eval = FALSE)
###################################################
## subNorm <- doNormalScore(sub)


###################################################
### code chunk number 26: RTools4TB.Rnw:319-320
###################################################
args(DBFMCL)


###################################################
### code chunk number 27: RTools4TB.Rnw:327-328 (eval = FALSE)
###################################################
## res <- DBFMCL(subNorm, distance.method="pearson", memory=512)


###################################################
### code chunk number 28: RTools4TB.Rnw:333-334 (eval = FALSE)
###################################################
## class(res)


###################################################
### code chunk number 29: RTools4TB.Rnw:342-343 (eval = FALSE)
###################################################
## res


###################################################
### code chunk number 30: RTools4TB.Rnw:370-371 (eval = FALSE)
###################################################
##  head(res@data[,1:2])


###################################################
### code chunk number 31: RTools4TB.Rnw:385-386 (eval = FALSE)
###################################################
## slotNames(res)


###################################################
### code chunk number 32: RTools4TB.Rnw:395-396 (eval = FALSE)
###################################################
## res@size


###################################################
### code chunk number 33: RTools4TB.Rnw:404-405 (eval = FALSE)
###################################################
## res@data[res@cluster ==1,]


###################################################
### code chunk number 34: RTools4TB.Rnw:410-411 (eval = FALSE)
###################################################
## plotGeneExpProfiles(res, sign=1)


###################################################
### code chunk number 35: RTools4TB.Rnw:415-416 (eval = FALSE)
###################################################
## writeDBFMCLresult(res, filename.out="ALL.sign.txt")


