### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:33-35
###################################################
options(width=60)
options(continue=" ")


###################################################
### code chunk number 2: preliminaries
###################################################
library(R453Plus1Toolbox)


###################################################
### code chunk number 3: createRocheAVASet
###################################################
avaDir = system.file("extdata", "AVASet", package = "R453Plus1Toolbox") 
avaSet = AVASet(avaDir)


###################################################
### code chunk number 4: showAVASet
###################################################
avaSet


###################################################
### code chunk number 5: assayDataAVA
###################################################
assayData(avaSet)$totalForwCount[1:3, ]


###################################################
### code chunk number 6: fDataAVA
###################################################
fData(avaSet)[1:3, ]


###################################################
### code chunk number 7: pDataAVA
###################################################
pData(avaSet)


###################################################
### code chunk number 8: assayDataAmpAVA
###################################################
assayDataAmp(avaSet)$forwCount


###################################################
### code chunk number 9: fDataAmpAVA
###################################################
fDataAmp(avaSet)


###################################################
### code chunk number 10: referenceSequences
###################################################
library(ShortRead)
referenceSequences(avaSet)
sread(referenceSequences(avaSet))


###################################################
### code chunk number 11: AVASubSet1
###################################################
avaSubSet = avaSet[1:10, "Sample_1"]


###################################################
### code chunk number 12: AVASubSet2
###################################################
avaSubSet = subset(avaSet, subset=1:10, dimension="variants")


###################################################
### code chunk number 13: AVASubSet3
###################################################
avaSubSet = subset(subset(avaSet, subset=1:10, dimension="variants"), subset="Sample_1", dimension="samples")


###################################################
### code chunk number 14: AVASubSet4
###################################################
avaSubSet = subset(avaSet, subset=c("TET2_E11.04", "TET2_E06"), dimension="amplicons")


###################################################
### code chunk number 15: filterAVA1
###################################################
avaSetFiltered1 = setVariantFilter(avaSet, filter=0.05)


###################################################
### code chunk number 16: filterAVA2
###################################################
avaSetFiltered2 = setVariantFilter(avaSet, filter=c(0.1, 0.05))


###################################################
### code chunk number 17: filterAVA4
###################################################
avaSet = setVariantFilter(avaSetFiltered1, filter=0)


###################################################
### code chunk number 18: filterAVA5
###################################################
avaSet = setVariantFilter(avaSetFiltered2)


###################################################
### code chunk number 19: varPercentages1
###################################################
getVariantPercentages(avaSet, direction="both")[20:25, 1:4]


###################################################
### code chunk number 20: varPercentages2
###################################################
(assayData(avaSet)[[1]] + assayData(avaSet)[[3]]) / (assayData(avaSet)[[2]] + assayData(avaSet)[[4]])


###################################################
### code chunk number 21: alignShortReads (eval = FALSE)
###################################################
## library(BSgenome.Hsapiens.UCSC.hg19)
## seqNames = names(Hsapiens)[1:24]
## avaSet = alignShortReads(avaSet, bsGenome=Hsapiens, seqNames=seqNames, ensemblNotation=TRUE)


###################################################
### code chunk number 22: annotateVariants (eval = FALSE)
###################################################
## avaSet = setVariantFilter(avaSet, filter=0.05)
## avaAnnot = annotateVariants(avaSet)


###################################################
### code chunk number 23: htmlReport (eval = FALSE)
###################################################
## blocks = as.character(sapply(annotatedVariants(avaAnnot), function(x) x$genes$external_gene_id))
## htmlReport(avaSet, annot=avaAnnot, blocks=blocks, dir="htmlReportExampleAVA", title="htmlReport Example", minMut=3)


###################################################
### code chunk number 24: plotAmpCov1
###################################################
plotAmpliconCoverage(avaSet[, 2], type="amplicon")


###################################################
### code chunk number 25: plotAmpCov2
###################################################
plotAmpliconCoverage(avaSet, bothDirections=TRUE, type="amplicon")


###################################################
### code chunk number 26: loadXLS
###################################################
file = system.file("extdata", "AVAVarFreqExport", "AVAVarFreqExport.xls", package="R453Plus1Toolbox")


###################################################
### code chunk number 27: plotVarFreq
###################################################
plotVariationFrequency(file, plotRange=c(50, 150))


###################################################
### code chunk number 28: loadXLS
###################################################
data(avaSetFiltered_annot)
data(transcriptdf)


###################################################
### code chunk number 29: plotVariants
###################################################
plotVariants(avaSetFiltered_annot, transcript=transcriptdf, legend=TRUE, regions=c(700,1600))


###################################################
### code chunk number 30: gsmDir1
###################################################
dir_sample01 = system.file("extdata", "MapperSet", "N01", package = "R453Plus1Toolbox")


###################################################
### code chunk number 31: gsmDir2
###################################################
dir_sample03 = system.file("extdata", "MapperSet", "N03", package = "R453Plus1Toolbox")


###################################################
### code chunk number 32: gsmDir3
###################################################
dir_sample04 = system.file("extdata", "MapperSet", "N04", package = "R453Plus1Toolbox")


###################################################
### code chunk number 33: gsmDir4
###################################################
dirs = c(dir_sample01, dir_sample03, dir_sample04)


###################################################
### code chunk number 34: createRocheGSMSet
###################################################
mapperSet = MapperSet(dirs=dirs, samplenames=c("N01", "N03", "N04"))


###################################################
### code chunk number 35: showMapperSet
###################################################
mapperSet


###################################################
### code chunk number 36: assayDataMapper1
###################################################
assayData(mapperSet)$variantForwCount[1:4, ]


###################################################
### code chunk number 37: assayDataMapper2
###################################################
assayData(mapperSet)$totalForwCount[1:4, ]


###################################################
### code chunk number 38: fDataMapper
###################################################
fData(mapperSet)[1:4, ]


###################################################
### code chunk number 39: pDataMapper
###################################################
pData(mapperSet)


###################################################
### code chunk number 40: annotateVarMapper (eval = FALSE)
###################################################
## mapperAnnot = annotateVariants(mapperSet)


###################################################
### code chunk number 41: htmlReportMapper (eval = FALSE)
###################################################
## htmlReport(mapperSet, annot=mapperAnnot, dir="htmlReportExampleMapper", title="htmlReport Example", minMut=3)


###################################################
### code chunk number 42: demultiplex
###################################################
fnaFile = system.file("extdata", "StructuralVariantDetection", "R_2009_07_30_14_26_52_FLX12080469_Administrator_714003", "D_2009_07_31_08_45_30_flxcluster_fullProcessing_714003", "1.TCA.454Reads.fna", package="R453Plus1Toolbox")
seqs = read.DNAStringSet(fnaFile, format="fasta")
MIDSeqs = genomeSequencerMIDs(c("MID1", "MID2", "MID3"))
dmReads = demultiplexReads(seqs, MIDSeqs, numMismatches=2, trim=TRUE)
length(seqs)
sum(sapply(dmReads, length))


###################################################
### code chunk number 43: removeLinker
###################################################
minReadLength = 15
gSel3 = sequenceCaptureLinkers("gSel3")[[1]]
trimReads = lapply(dmReads, function (reads) {
reads = reads[width(reads) >= minReadLength]
reads = removeLinker(reads, gSel3)
reads = reads[width(reads) >= minReadLength]
readsRev = reverseComplement(reads)
readsRev = removeLinker(readsRev, gSel3)
reads = reverseComplement(readsRev)
reads = reads[width(reads) >= minReadLength]
return(reads)
})


###################################################
### code chunk number 44: writeFASTA (eval = FALSE)
###################################################
## write.XStringSet(trimReads[["MID1"]], file="/tmp/N01.fasta", format="fasta")


###################################################
### code chunk number 45: readBam
###################################################
library("Rsamtools")
bamFile = system.file("extdata", "StructuralVariantDetection", "bam", "N01.bam", package="R453Plus1Toolbox")
parameters = ScanBamParam(what=scanBamWhat())
bam = scanBam(bamFile, param=parameters)


###################################################
### code chunk number 46: filterReads
###################################################
library("rtracklayer")
bedFile = system.file("extdata", "StructuralVariantDetection", "chip", "CaptureArray_hg19.bed", package="R453Plus1Toolbox")
chip = import.ucsc(bedFile, subformat="bed")
chip = ranges(chip[[1]])
names(chip) = gsub("chr", "", names(chip))

linker = sequenceCaptureLinkers("gSel3")[[1]]

filterReads = filterChimericReads(bam, targetRegion=chip, linkerSeq=linker)
filterReads$log


###################################################
### code chunk number 47: detectBreakpoints
###################################################
bp = detectBreakpoints(filterReads, minClusterSize=1)
bp
table(bp)

mbp = mergeBreakpoints(bp)
summary(mbp)


###################################################
### code chunk number 48: plotCR1
###################################################
plotChimericReads(mbp[1], legend=TRUE)


###################################################
### code chunk number 49: plotCR2
###################################################
plotChimericReads(mbp[1], plotBasePairs=TRUE, maxBasePairs=30)


