/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

public class EquationUtil {
    public static String attribNameAsReference(String attribName) {
        if (EquationUtil.isSimpleAttribName(attribName)) {
            return "$" + attribName;
        }
        return "${" + EquationUtil.escapeAttribName(attribName) + "}";
    }

    public static long doubleToLong(double d) {
        if (d > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw new IllegalArgumentException("floating point value is too large to be converted to a Long!");
        }
        double x = Double.valueOf(d).longValue();
        if (x != d && x < 0.0) {
            x -= 1.0;
        }
        return (long)x;
    }

    private static boolean isSimpleAttribName(String attribName) {
        int length = attribName.length();
        if (length == 0) {
            throw new IllegalStateException("empty attribute names should never happen!");
        }
        if (!Character.isLetter(attribName.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char ch = attribName.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    private static String escapeAttribName(String attribName) {
        int length = attribName.length();
        StringBuilder escapedAttribName = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char ch = attribName.charAt(i);
            switch (ch) {
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case ':': 
                case '\\': 
                case '{': 
                case '}': {
                    escapedAttribName.append('\\');
                }
            }
            escapedAttribName.append(ch);
        }
        return escapedAttribName.toString();
    }
}

