/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.VizMapperTrackRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

public class ContinuousTrackRenderer
extends JComponent
implements VizMapperTrackRenderer {
    private static float UPPER_LIMIT;
    private final Font TITLE_FONT = new Font("SansSerif", 1, 12);
    private static final Font ICON_FONT;
    private static final int THUMB_WIDTH = 12;
    private final Font smallFont = new Font("SansSerif", 1, 10);
    private final Font defFont = new Font("SansSerif", 1, 12);
    private static final Color VALUE_AREA_COLOR;
    private Map<Integer, Double> valueMap;
    private static final int LEFT_SPACE = 50;
    private int trackHeight = 120;
    private int arrowBarPosition = this.trackHeight + 50;
    private static final Color BORDER_COLOR;
    private float min = 0.0f;
    private float max = 0.0f;
    private boolean clickFlag = false;
    private boolean dragFlag = false;
    private Point curPoint;
    private JXMultiThumbSlider slider;
    private CMouseListener listener = null;
    private Map<Integer, Point> verticesList;
    private int selectedIdx;
    private Point dragOrigin;
    private VisualPropertyType type;
    private ContinuousMapping cMapping;
    private String title;
    private Number below;
    private Number above;
    private List<Float> values = new ArrayList<Float>();
    private Polygon valueArea = new Polygon();
    private Point belowSquare;
    private Point aboveSquare;

    public ContinuousTrackRenderer(VisualPropertyType type, Number below, Number above) {
        this.below = below;
        this.above = above;
        this.type = type;
        this.cMapping = type.isNodeProp() ? (ContinuousMapping)Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0) : (ContinuousMapping)Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0);
        this.title = this.cMapping.getControllingAttributeName();
        String propStr = CytoscapeInit.getProperties().getProperty("vizmapper.cntMapperUpperLimit");
        if (propStr != null) {
            Float val;
            try {
                val = Float.valueOf(Float.parseFloat(propStr.toString()));
            }
            catch (NumberFormatException e) {
                val = Float.valueOf(2000.0f);
            }
            UPPER_LIMIT = val.floatValue();
        } else {
            UPPER_LIMIT = 2000.0f;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    protected void removeSquare(Integer index) {
        CyLogger.getLogger().info("\n\nTrying to remove " + index);
        for (Integer key : this.verticesList.keySet()) {
            CyLogger.getLogger().info("Key = " + key + ", " + this.verticesList.get(key));
        }
        this.verticesList.remove(index);
        for (Integer key : this.verticesList.keySet()) {
            CyLogger.getLogger().info("Key After = " + key + ", " + this.verticesList.get(key));
        }
    }

    protected void paintComponent(Graphics gfx) {
        this.trackHeight = this.slider.getHeight() - 100;
        this.arrowBarPosition = this.trackHeight + 50;
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        int thumb_width = 12;
        int track_width = this.slider.getWidth() - thumb_width;
        g.translate(thumb_width / 2, 12);
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Float[] floatProperty = new Float[numPoints];
        int i = 0;
        this.values.clear();
        this.values.add(Float.valueOf(this.below.floatValue()));
        this.values.add(Float.valueOf(this.above.floatValue()));
        for (Thumb thumb : stops) {
            floatProperty[i] = (Float)thumb.getObject();
            fractions[i] = thumb.getPosition();
            this.values.add((Float)thumb.getObject());
            ++i;
        }
        for (Float val : this.values) {
            if (this.min >= val.floatValue()) {
                this.min = val.floatValue();
            }
            if (!(this.max <= val.floatValue())) continue;
            this.max = val.floatValue();
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.drawLine(0, this.arrowBarPosition, track_width, this.arrowBarPosition);
        Polygon arrow = new Polygon();
        arrow.addPoint(track_width, this.arrowBarPosition);
        arrow.addPoint(track_width - 20, this.arrowBarPosition - 8);
        arrow.addPoint(track_width - 20, this.arrowBarPosition);
        g.fill(arrow);
        g.setColor(Color.gray);
        g.drawLine(0, this.arrowBarPosition, 15, this.arrowBarPosition - 30);
        g.drawLine(15, this.arrowBarPosition - 30, 25, this.arrowBarPosition - 30);
        g.setFont(this.smallFont);
        g.drawString("Min=" + minValue, 28, this.arrowBarPosition - 25);
        g.drawLine(track_width, this.arrowBarPosition, track_width - 15, this.arrowBarPosition + 30);
        g.drawLine(track_width - 15, this.arrowBarPosition + 30, track_width - 25, this.arrowBarPosition + 30);
        String maxStr = "Max=" + maxValue;
        int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
        g.drawString(maxStr, track_width - strWidth - 26, this.arrowBarPosition + 35);
        g.setFont(this.defFont);
        g.setColor(Color.black);
        strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
        g.drawString(this.title, track_width / 2 - strWidth / 2, this.arrowBarPosition + 35);
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.drawRect(0, 5, track_width, this.trackHeight);
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.white);
        g.fillRect(0, 5, track_width, this.trackHeight);
        int newX = 0;
        int lastY = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < floatProperty.length; ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 5.0);
            int newY = 5 + this.trackHeight - (int)(floatProperty[i].floatValue() / this.max * (float)this.trackHeight);
            this.valueArea.reset();
            g.setColor(VALUE_AREA_COLOR);
            if (i == 0) {
                int h = 5 + this.trackHeight - (int)(this.below.floatValue() / this.max * (float)this.trackHeight);
                g.fillRect(0, h, newX, (int)(this.below.floatValue() / this.max * (float)this.trackHeight));
                g.setColor(Color.red);
                g.fillRect(-5, h - 5, 10, 10);
                this.belowSquare = new Point(0, h);
            } else {
                this.valueArea.addPoint((int)((Point2D)p1).getX(), lastY);
                this.valueArea.addPoint(newX, newY);
                this.valueArea.addPoint(newX, this.trackHeight + 5);
                this.valueArea.addPoint((int)((Point2D)p1).getX(), this.trackHeight + 5);
                g.fill(this.valueArea);
            }
            for (int j = 0; j < stops.size(); ++j) {
                if (this.slider.getModel().getThumbAt(j).getObject() != floatProperty[i]) continue;
                Point newPoint = new Point(newX, newY);
                if (this.verticesList.containsValue(newPoint)) break;
                this.verticesList.put(j, new Point(newX, newY));
                break;
            }
            lastY = newY;
            g.setColor(Color.black);
            g.setStroke(new BasicStroke(1.5f));
            g.setFont(this.smallFont);
            int numberWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), floatProperty[i].toString());
            g.setColor(Color.DARK_GRAY);
            if (fractions[i] < 10.0f) {
                g.drawLine(newX, newY, newX + 15, newY - 35);
                g.drawString(floatProperty[i].toString(), newX + numberWidth, newY - 48);
            } else {
                g.drawLine(newX, newY, newX - 15, newY + 35);
                g.drawString(floatProperty[i].toString(), newX - (numberWidth + 5), newY + 48);
            }
            g.setColor(Color.DARK_GRAY);
            g.setFont(new Font("SansSerif", 1, 10));
            Float curPositionValue = Float.valueOf(Double.valueOf((double)(fractions[i] / 100.0f) * EditorValueRangeTracer.getTracer().getRange(this.type) + minValue).floatValue());
            String valueString = String.format("%.4f", curPositionValue);
            int flipLimit = 90;
            int borderVal = track_width - newX;
            if (i % 2 == 0 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX + 20, this.arrowBarPosition - 15);
                g.drawLine(newX + 20, this.arrowBarPosition - 15, newX + 30, this.arrowBarPosition - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, this.arrowBarPosition - 11);
            } else if (i % 2 == 1 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX + 20, this.arrowBarPosition + 15);
                g.drawLine(newX + 20, this.arrowBarPosition + 15, newX + 30, this.arrowBarPosition + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, this.arrowBarPosition + 19);
            } else if (i % 2 == 0 && flipLimit >= borderVal) {
                g.drawLine(newX, this.arrowBarPosition, newX - 20, this.arrowBarPosition - 15);
                g.drawLine(newX - 20, this.arrowBarPosition - 15, newX - 30, this.arrowBarPosition - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, this.arrowBarPosition - 11);
            } else {
                g.drawLine(newX, this.arrowBarPosition, newX - 20, this.arrowBarPosition + 15);
                g.drawLine(newX - 20, this.arrowBarPosition + 15, newX - 30, this.arrowBarPosition + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, this.arrowBarPosition + 19);
            }
            g.setColor(Color.black);
            g.fillOval(newX - 3, this.arrowBarPosition - 3, 6, 6);
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 5.0);
        g.setColor(VALUE_AREA_COLOR);
        int h = 5 + this.trackHeight - (int)(this.above.floatValue() / this.max * (float)this.trackHeight);
        g.fillRect((int)((Point2D)p1).getX(), h, track_width - (int)((Point2D)p1).getX(), (int)(this.above.floatValue() / this.max * (float)this.trackHeight));
        g.setColor(Color.red);
        g.fillRect(track_width - 5, h - 5, 10, 10);
        this.aboveSquare = new Point(track_width, h);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        g.drawRect(0, 5, track_width, this.trackHeight);
        g.setColor(Color.red);
        g.setStroke(new BasicStroke(1.5f));
        for (Integer key : this.verticesList.keySet()) {
            Point p = this.verticesList.get(key);
            if (this.clickFlag) {
                int diffX = Math.abs(p.x - (this.curPoint.x - 6));
                int diffY = Math.abs(p.y - (this.curPoint.y - 12));
                if (diffX < 6 && diffY < 6 || key == this.selectedIdx) {
                    g.setColor(Color.green);
                    g.setStroke(new BasicStroke(2.5f));
                } else {
                    g.setColor(Color.red);
                    g.setStroke(new BasicStroke(1.5f));
                }
            }
            g.drawRect(p.x - 5, p.y - 5, 10, 10);
        }
        g.translate(-6, -12);
    }

    public Double getSelectedThumbValue() {
        Double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        Double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        float position = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).getPosition();
        return (double)(position / 100.0f) * valueRange + minValue;
    }

    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        if (this.listener == null) {
            this.listener = new CMouseListener();
            this.slider.addMouseListener(this.listener);
            this.slider.addMouseMotionListener(new CMouseMotionListener());
        }
        if (this.verticesList == null) {
            this.verticesList = new HashMap<Integer, Point>();
        }
        if (this.valueMap == null) {
            this.valueMap = new HashMap<Integer, Double>();
        }
        return this;
    }

    public ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, false);
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, true);
    }

    private ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        g.setColor(Color.white);
        g.fillRect(0, 0, iconWidth, iconHeight);
        int leftSpace = 10;
        int trackHeight = iconHeight - 9;
        int trackWidth = iconWidth - leftSpace;
        List stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Float[] floatProperty = new Float[numPoints];
        int i = 0;
        this.values.clear();
        this.values.add(Float.valueOf(this.below.floatValue()));
        this.values.add(Float.valueOf(this.above.floatValue()));
        for (Thumb thumb : stops) {
            floatProperty[i] = (Float)thumb.getObject();
            fractions[i] = thumb.getPosition();
            this.values.add((Float)thumb.getObject());
            ++i;
        }
        for (Float val : this.values) {
            if (this.min >= val.floatValue()) {
                this.min = val.floatValue();
            }
            if (!(this.max <= val.floatValue())) continue;
            this.max = val.floatValue();
        }
        g.setColor(Color.DARK_GRAY);
        g.setFont(ICON_FONT);
        int minWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), String.format("%.1f", Float.valueOf(this.min)));
        int maxWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), String.format("%.1f", Float.valueOf(this.max)));
        if (detail) {
            leftSpace = 50;
            trackHeight = iconHeight - 30;
        } else {
            leftSpace = Math.max(minWidth, maxWidth) + 1;
        }
        trackWidth = iconWidth - leftSpace;
        g.drawString(String.format("%.1f", Float.valueOf(this.min)), 0, trackHeight);
        g.drawString(String.format("%.1f", Float.valueOf(this.max)), 0, 8);
        if (numPoints == 0) {
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(Color.DARK_GRAY);
            g.drawRect(leftSpace, 0, trackWidth - 3, trackHeight);
            return new ImageIcon(bi);
        }
        g.translate(leftSpace, 0);
        g.setStroke(new BasicStroke(1.0f));
        int newX = 0;
        int lastY = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 0.0f);
        for (i = 0; i < floatProperty.length; ++i) {
            newX = (int)((float)trackWidth * (fractions[i] / 100.0f)) - 3;
            if (newX < 0) {
                newX = 0;
            }
            ((Point2D)p2).setLocation(newX, 0.0);
            int newY = trackHeight - (int)(floatProperty[i].floatValue() / this.max * (float)trackHeight);
            this.valueArea.reset();
            g.setColor(VALUE_AREA_COLOR);
            if (i == 0) {
                int h = trackHeight - (int)(this.below.floatValue() / this.max * (float)trackHeight);
                g.fillRect(0, h, newX, (int)(this.below.floatValue() / this.max * (float)trackHeight));
            } else {
                this.valueArea.addPoint((int)((Point2D)p1).getX(), lastY);
                this.valueArea.addPoint(newX, newY);
                this.valueArea.addPoint(newX, trackHeight);
                this.valueArea.addPoint((int)((Point2D)p1).getX(), trackHeight);
                g.fill(this.valueArea);
            }
            for (int j = 0; j < stops.size(); ++j) {
                if (this.slider.getModel().getThumbAt(j).getObject() != floatProperty[i]) continue;
                Point newPoint = new Point(newX, newY);
                if (this.verticesList.containsValue(newPoint)) break;
                this.verticesList.put(j, new Point(newX, newY));
                break;
            }
            lastY = newY;
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(trackWidth, 0.0);
        g.setColor(VALUE_AREA_COLOR);
        int h = trackHeight - (int)(this.above.floatValue() / this.max * (float)trackHeight);
        g.fillRect((int)((Point2D)p1).getX(), h, trackWidth - (int)((Point2D)p1).getX() - 3, (int)(this.above.floatValue() / this.max * (float)trackHeight));
        g.translate(-leftSpace, 0);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRect(leftSpace, 0, trackWidth - 3, trackHeight);
        g.setFont(new Font("SansSerif", 1, 9));
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g.setColor(Color.black);
        if (detail) {
            int strWidth;
            String fNum = null;
            for (int j = 0; j < fractions.length; ++j) {
                fNum = String.format("%.2f", (double)(fractions[j] / 100.0f) * valueRange + minValue);
                strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fNum);
                g.drawString(fNum, fractions[j] / 100.0f * (float)trackWidth - (float)(strWidth / 2) + (float)leftSpace, (float)(iconHeight - 20));
            }
            g.drawString(minStr, leftSpace, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g.setFont(this.TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
            g.setColor(Color.black);
            g.drawString(this.title, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g.fillPolygon(p);
            g.drawLine(leftSpace, iconHeight - 9, (iconWidth - leftSpace) / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
            int panelHeight = iconHeight - 30;
            Polygon poly = new Polygon();
            int top = 0;
            g.setStroke(new BasicStroke(1.0f));
            int center = leftSpace / 2 + 6;
            poly.addPoint(center, top);
            poly.addPoint(center - 6, top + 15);
            poly.addPoint(center, top + 15);
            g.fillPolygon(poly);
            g.drawLine(center, top, center, panelHeight);
            g.setColor(Color.DARK_GRAY);
            g.setFont(new Font("SansSerif", 1, 10));
            String label = this.type.getName();
            int width = SwingUtilities.computeStringWidth(g.getFontMetrics(), label);
            AffineTransform af = new AffineTransform();
            af.rotate(4.71238898038469);
            g.setTransform(af);
            g.setColor(Color.black);
            g.drawString(this.type.getName(), -panelHeight / 2 - width / 2, leftSpace / 2 + 5);
        } else {
            g.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    static {
        ICON_FONT = new Font("SansSerif", 1, 8);
        VALUE_AREA_COLOR = new Color(0, 180, 255, 100);
        BORDER_COLOR = Color.black;
    }

    class CMouseListener
    extends MouseAdapter {
        CMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.isPointerInSquare(e) && e.getClickCount() == 2) {
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for this pivot.");
                if (val == null) {
                    return;
                }
                Float newVal = Float.valueOf(0.0f);
                try {
                    newVal = Float.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                ContinuousTrackRenderer.this.slider.getModel().getThumbAt(ContinuousTrackRenderer.this.selectedIdx).setObject(newVal);
                this.updateMax();
                ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().equalValue = newVal;
                BoundaryRangeValues brv = new BoundaryRangeValues(((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().lesserValue, newVal, ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().greaterValue);
                ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.selectedIdx).setRange(brv);
                int numPoints = ContinuousTrackRenderer.this.cMapping.getAllPoints().size();
                if (numPoints > 1) {
                    if (ContinuousTrackRenderer.this.selectedIdx == 0) {
                        brv.greaterValue = newVal;
                    } else if (ContinuousTrackRenderer.this.selectedIdx == numPoints - 1) {
                        brv.lesserValue = newVal;
                    } else {
                        brv.lesserValue = newVal;
                        brv.greaterValue = newVal;
                    }
                    ContinuousTrackRenderer.this.cMapping.fireStateChanged();
                    Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
                    ContinuousTrackRenderer.this.slider.repaint();
                }
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
            } else if (e.getClickCount() == 2 && this.isBelow(e.getPoint())) {
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for BELOW:");
                if (val == null) {
                    return;
                }
                try {
                    ContinuousTrackRenderer.this.below = Float.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                Number newValue = ContinuousTrackRenderer.this.below;
                BoundaryRangeValues original = ContinuousTrackRenderer.this.cMapping.getPoint(0).getRange();
                BoundaryRangeValues brv = new BoundaryRangeValues(newValue, original.equalValue, original.greaterValue);
                ContinuousTrackRenderer.this.cMapping.getPoint(0).setRange(brv);
                ContinuousTrackRenderer.this.cMapping.fireStateChanged();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.firePropertyChange("BELOW_VALUE_CHANGED", null, ContinuousTrackRenderer.this.below);
            } else if (e.getClickCount() == 2 && this.isAbove(e.getPoint())) {
                String val = JOptionPane.showInputDialog(ContinuousTrackRenderer.this.slider, (Object)"Please type new value for ABOVE:");
                if (val == null) {
                    return;
                }
                try {
                    ContinuousTrackRenderer.this.above = Float.valueOf(val);
                }
                catch (Exception ne) {
                    return;
                }
                BoundaryRangeValues original = ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.cMapping.getPointCount() - 1).getRange();
                BoundaryRangeValues brv = new BoundaryRangeValues(original.lesserValue, original.equalValue, ContinuousTrackRenderer.this.above);
                ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.cMapping.getPointCount() - 1).setRange(brv);
                ContinuousTrackRenderer.this.cMapping.fireStateChanged();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
                ContinuousTrackRenderer.this.slider.repaint();
                ContinuousTrackRenderer.this.repaint();
                ContinuousTrackRenderer.this.firePropertyChange("ABOVE_VALUE_CHANGED", null, ContinuousTrackRenderer.this.above);
            }
        }

        private boolean isBelow(Point p) {
            if (ContinuousTrackRenderer.this.belowSquare == null) {
                return false;
            }
            int diffY = Math.abs(p.y - 12 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).belowSquare.y);
            int diffX = Math.abs(p.x - 6 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).belowSquare.x);
            return diffX < 6 && diffY < 6;
        }

        private boolean isAbove(Point p) {
            if (ContinuousTrackRenderer.this.aboveSquare == null) {
                return false;
            }
            int diffY = Math.abs(p.y - 12 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).aboveSquare.y);
            int diffX = Math.abs(p.x - 6 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).aboveSquare.x);
            return diffX < 6 && diffY < 6;
        }

        public void mousePressed(MouseEvent e) {
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            ContinuousTrackRenderer.this.dragOrigin = e.getPoint();
            for (Integer key : ContinuousTrackRenderer.this.verticesList.keySet()) {
                Point p = (Point)ContinuousTrackRenderer.this.verticesList.get(key);
                int diffY = Math.abs(p.y + 12 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).curPoint.y);
                int diffX = Math.abs(p.x + 6 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).curPoint.x);
                if (diffX >= 6 || diffY >= 6) continue;
                ContinuousTrackRenderer.this.selectedIdx = key;
                ContinuousTrackRenderer.this.clickFlag = true;
            }
        }

        public void mouseReleased(MouseEvent arg0) {
            ContinuousTrackRenderer.this.clickFlag = false;
            this.updateMax();
            if (ContinuousTrackRenderer.this.slider.getSelectedThumb() == null) {
                ContinuousTrackRenderer.this.slider.repaint();
            }
            ContinuousTrackRenderer.this.repaint();
            if (ContinuousTrackRenderer.this.dragFlag) {
                ContinuousTrackRenderer.this.dragFlag = false;
                ContinuousTrackRenderer.this.cMapping.fireStateChanged();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            }
        }

        private boolean isPointerInSquare(MouseEvent e) {
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            ContinuousTrackRenderer.this.dragOrigin = e.getPoint();
            for (Integer key : ContinuousTrackRenderer.this.verticesList.keySet()) {
                Point p = (Point)ContinuousTrackRenderer.this.verticesList.get(key);
                int diffY = Math.abs(p.y + 12 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).curPoint.y);
                int diffX = Math.abs(p.x + 6 - ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).curPoint.x);
                if (diffX >= 6 || diffY >= 6) continue;
                ContinuousTrackRenderer.this.selectedIdx = key;
                return true;
            }
            return false;
        }

        private void updateMax() {
            Float curMax = Float.valueOf(0.0f);
            for (Thumb thumb : ContinuousTrackRenderer.this.slider.getModel().getSortedThumbs()) {
                Float val = (Float)thumb.getObject();
                if (!(val.floatValue() > curMax.floatValue())) continue;
                curMax = val;
            }
            ContinuousTrackRenderer.this.max = curMax.floatValue();
        }
    }

    class CMouseMotionListener
    implements MouseMotionListener {
        CMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            if (e.getY() < 12 && !ContinuousTrackRenderer.this.dragFlag) {
                return;
            }
            ContinuousTrackRenderer.this.dragFlag = true;
            ContinuousTrackRenderer.this.curPoint = e.getPoint();
            if (ContinuousTrackRenderer.this.clickFlag) {
                Thumb<Float> selectedThumb = ContinuousTrackRenderer.this.slider.getModel().getThumbAt(ContinuousTrackRenderer.this.selectedIdx);
                if (ContinuousTrackRenderer.this.curPoint.getY() >= (double)(ContinuousTrackRenderer.this.trackHeight + 5)) {
                    selectedThumb.setObject(Float.valueOf(0.0f));
                    return;
                }
                double curY = ContinuousTrackRenderer.this.curPoint.getY();
                float newY = (float)(((double)(ContinuousTrackRenderer.this.trackHeight + 5) - curY) * (double)ContinuousTrackRenderer.this.max / (double)(ContinuousTrackRenderer.this.trackHeight + 5));
                if (newY > UPPER_LIMIT) {
                    newY = UPPER_LIMIT;
                }
                selectedThumb.setObject(Float.valueOf(newY));
                Float newVal = Float.valueOf(newY);
                ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().equalValue = newVal;
                BoundaryRangeValues brv = new BoundaryRangeValues(((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().lesserValue, newVal, ((ContinuousTrackRenderer)ContinuousTrackRenderer.this).cMapping.getPoint((int)((ContinuousTrackRenderer)ContinuousTrackRenderer.this).selectedIdx).getRange().greaterValue);
                ContinuousTrackRenderer.this.cMapping.getPoint(ContinuousTrackRenderer.this.selectedIdx).setRange(brv);
                int numPoints = ContinuousTrackRenderer.this.cMapping.getAllPoints().size();
                if (numPoints > 1) {
                    if (ContinuousTrackRenderer.this.selectedIdx == 0) {
                        brv.greaterValue = newVal;
                    } else if (ContinuousTrackRenderer.this.selectedIdx == numPoints - 1) {
                        brv.lesserValue = newVal;
                    } else {
                        brv.lesserValue = newVal;
                        brv.greaterValue = newVal;
                    }
                }
            }
            ContinuousTrackRenderer.this.dragOrigin = e.getPoint();
            ContinuousTrackRenderer.this.slider.repaint();
        }

        public void mouseMoved(MouseEvent arg0) {
        }
    }
}

