/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteRangeCalculator<T, V> {
    private SortedMap<T, V> map;
    private String attrName;

    public DiscreteRangeCalculator(SortedMap<T, V> map, String attrName) {
        this.map = map;
        this.attrName = attrName;
    }

    public V calculateRangeValue(Map<String, Object> attrBundle) {
        if (attrBundle == null || this.attrName == null) {
            return null;
        }
        Object attrValue = attrBundle.get(this.attrName);
        if (attrValue == null) {
            return null;
        }
        try {
            if (attrValue instanceof List) {
                for (Object attrSubValue : (List)attrValue) {
                    if (this.map.get(attrSubValue) == null) continue;
                    return this.map.get(attrSubValue);
                }
                return null;
            }
            return this.map.get(attrValue);
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

