/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.util.CharacterDocument;
import com.sun.glf.util.Glyph;
import com.sun.glf.util.GlyphPanel;
import com.sun.glf.util.GlyphPreview;
import com.sun.glf.util.GridBagConstants;
import com.sun.glf.util.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GlyphChooser
implements GridBagConstants {
    static final String GLYPH_CHOOSER = "Glyph Chooser";
    static final String FONT_NAME = "Font Name: ";
    static final String FONT_SIZE = "Size: ";
    static final String RANGE = "Range: ";
    static final String ERROR_INVALID_FONT_SIZE = "Error: invalid font size : should be a number";
    static final String OK = "OK";
    static final String CANCEL = "Cancel";
    static final String TO = "to:";
    static final String PREDEFINED_RANGES = "Predefined Ranges:";
    static final String BASIC_LATIN = "Basic Latin";
    static final String LATIN_1 = "Latin 1";
    static final String LATIN_EXTENDED_A = "Latin Extended-A";
    static final String LATIN_EXTENDED_B = "Latin Extended-B";
    static final String IPA_EXTENSIONS = "IPA Extensions";
    static final String SPACING_MODIFIERS = "Spacing Modifiers";
    static final String COMBINING_DIACRITICAL_MARKS = "Combining Diacritical Marks";
    static final String GREEK = "Greek";
    static final String CYRILLIC = "Cyrillic";
    static final String HEBREW = "Hebrew";
    static final String ARABIC = "Arabic";
    static final String DEVANAGARI = "Devanagari";
    static final String THAI = "Thai";
    static final String LATIN_EXTENDED_ADDITIONAL = "Latin Extended Additional";
    static final String GREEK_EXTENDED = "Greek Extended";
    static final String GENERAL_PUNCTUATION = "General Punctuation";
    static final String SUPERSCRIPTS_AND_SUBSCRIPTS = "Superscripts and Subscripts";
    static final String CURRENCY = "Currency";
    static final String LETTERLIKE_SYMBOLS = "Letterlike Symbols";
    static final String NUMBER_FORMS = "Number Forms";
    static final String ARROWS = "Arrows";
    static final String MATHEMATICAL_OPERATORS = "Mathematical Operators";
    static final String MISCELLANEOUS_TECHNICAL = "Miscellaneous Technical";
    static final String CONTROL_PICTURES = "Control Pictures";
    static final String ENCLOSED_ALPHANUMERICS = "Enclosed Alphanumerics";
    static final String BOX_DRAWING = "Box Drawing";
    static final String BLOCK_ELEMENTS = "Block Elements";
    static final String GEOMETRIC_SHAPES = "Geometric Shapes";
    static final String MISCELLANEOUS_SYMBOLS = "Miscellaneous Symbols";
    static final String DINGBATS = "Dingbats";
    static final String ALPHABETIC_PRES_FORMS = "Alphabetic Pres. Forms";
    static final String ARABIC_PRES_FORMS_A = "Arabic Pres Forms-A";
    static final String ARABIC_PRES_FORMS_B = "Arabic Pres Forms-B";
    static UnicodeRange[] ranges = new UnicodeRange[]{new UnicodeRange("Basic Latin", '\u0000'), new UnicodeRange("Latin 1", '\u0080'), new UnicodeRange("Latin Extended-A", '\u0100'), new UnicodeRange("Latin Extended-B", '\u0180'), new UnicodeRange("IPA Extensions", '\u0250'), new UnicodeRange("Spacing Modifiers", '\u02b0'), new UnicodeRange("Combining Diacritical Marks", '\u0300'), new UnicodeRange("Greek", '\u0370'), new UnicodeRange("Cyrillic", '\u0400'), new UnicodeRange("Hebrew", '\u0590'), new UnicodeRange("Arabic", '\u0600'), new UnicodeRange("Devanagari", '\u0900'), new UnicodeRange("Thai", '\u0e00'), new UnicodeRange("Latin Extended Additional", '\u1e00'), new UnicodeRange("Greek Extended", '\u1f00'), new UnicodeRange("General Punctuation", '\u2000'), new UnicodeRange("Superscripts and Subscripts", '\u2070'), new UnicodeRange("Currency", '\u20a0'), new UnicodeRange("Letterlike Symbols", '\u2100'), new UnicodeRange("Number Forms", '\u2150'), new UnicodeRange("Arrows", '\u2190'), new UnicodeRange("Mathematical Operators", '\u2200'), new UnicodeRange("Miscellaneous Technical", '\u2300'), new UnicodeRange("Control Pictures", '\u2400'), new UnicodeRange("Enclosed Alphanumerics", '\u2460'), new UnicodeRange("Box Drawing", '\u2500'), new UnicodeRange("Block Elements", '\u2580'), new UnicodeRange("Geometric Shapes", '\u25a0'), new UnicodeRange("Miscellaneous Symbols", '\u2600'), new UnicodeRange("Dingbats", '\u2700'), new UnicodeRange("Alphabetic Pres. Forms", '\ufb00'), new UnicodeRange("Arabic Pres Forms-A", '\ufb50'), new UnicodeRange("Arabic Pres Forms-B", '\ufb70')};
    static String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "32", "36", "48", "72"};
    static JDialog dialog;
    static JComboBox fontList;
    static JComboBox fontSize;
    static JComboBox predefinedRanges;
    static JTextField range;
    static JLabel rangeEnd;
    static GlyphPreview preview;
    static GlyphPanel glyphPanel;
    static Glyph retVal;
    static final Font defaultFont;
    static final Glyph defaultGlyph;
    static String[] fontNames;
    static Hashtable fontMap;

    GlyphChooser() {
    }

    static void buildDialog() {
        Serializable serializable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        int n = fontArray != null ? fontArray.length : 0;
        fontNames = new String[n];
        fontMap = new Hashtable();
        for (int i = 0; i < n; ++i) {
            serializable = fontArray[i];
            GlyphChooser.fontNames[i] = ((Font)serializable).getName();
            fontMap.put(fontNames[i], serializable);
        }
        dialog = new JDialog((Frame)null, GLYPH_CHOOSER, true);
        fontList = new JComboBox<String>(fontNames);
        fontSize = new JComboBox<String>(fontSizes);
        fontSize.setEditable(true);
        preview = new GlyphPreview(false);
        CharacterDocument characterDocument = new CharacterDocument();
        range = new JTextField(characterDocument, "", 4);
        rangeEnd = new JLabel("0000");
        predefinedRanges = new JComboBox<UnicodeRange>(ranges);
        serializable = new GridBagPanel();
        ((GridBagPanel)serializable).add(new JLabel(FONT_NAME), 0, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(fontList, 0, 1, 1, 1, 10, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(new JLabel(FONT_SIZE), 1, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(fontSize, 1, 1, 1, 1, 17, 2, 0.0, 0.0);
        ((GridBagPanel)serializable).add(new JLabel(PREDEFINED_RANGES), 2, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(predefinedRanges, 2, 1, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(new JLabel(RANGE), 3, 0, 1, 1, 17, 0, 0.0, 0.0);
        ((GridBagPanel)serializable).add(range, 3, 1, 1, 1, 17, 2, 0.0, 0.0);
        ((GridBagPanel)serializable).add(Box.createHorizontalGlue(), 5, 0, 1, 1, 17, 2, 1.0, 0.0);
        glyphPanel = new GlyphPanel();
        preview.setPreferredSize(new Dimension(GlyphChooser.glyphPanel.getPreferredSize().height, GlyphChooser.glyphPanel.getPreferredSize().height));
        range.setPreferredSize(new Dimension(GlyphChooser.range.getPreferredSize().width, GlyphChooser.predefinedRanges.getPreferredSize().height));
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.add(glyphPanel, 0, 0, 1, 1, 10, 1, 1.0, 1.0);
        gridBagPanel.add(preview, 1, 0, 0, 1, 10, 1, 1.0, 1.0);
        glyphPanel.setBackground(Color.white);
        preview.setBackground(Color.white);
        ((GridBagPanel)serializable).add(gridBagPanel, 0, 2, 0, 1, 10, 1, 1.0, 1.0);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        JButton jButton = new JButton(OK);
        JButton jButton2 = new JButton(CANCEL);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        gridBagPanel2.add(Box.createHorizontalGlue(), 0, 0, 1, 1, 13, 2, 1.0, 0.0);
        gridBagPanel2.add(jPanel, 0, 0, 1, 1, 13, 0, 0.0, 0.0);
        ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        glyphPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        preview.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        dialog.setVisible(false);
        dialog.setModal(true);
        Container container = dialog.getContentPane();
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add("Center", (Component)serializable);
        container.add("South", gridBagPanel2);
        dialog.pack();
        fontList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlyphChooser.onFontChange();
            }
        });
        fontSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlyphChooser.onFontChange();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                retVal = null;
                dialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                retVal = preview.getGlyph();
                dialog.dispose();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        glyphPanel.addSelectedChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Glyph glyph = glyphPanel.getSelected();
                preview.setGlyph(glyph);
            }
        });
        range.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                char c = (char)Integer.parseInt(range.getText(), 16);
                glyphPanel.setRange(c);
                preview.setGlyph(glyphPanel.getSelected());
                int n = 65535;
                if (65535 - c >= 255) {
                    n = (char)(c + 255);
                    rangeEnd.setText(Integer.toHexString(n));
                }
            }
        });
        predefinedRanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnicodeRange unicodeRange = (UnicodeRange)predefinedRanges.getSelectedItem();
                if (unicodeRange != null) {
                    char c = unicodeRange.cStart;
                    range.setText("" + Integer.toHexString(0xFFFF & c));
                    glyphPanel.setRange(c);
                    preview.setGlyph(glyphPanel.getSelected());
                    int n = 65535;
                    if (65535 - c >= 255) {
                        n = (char)(c + 255);
                        rangeEnd.setText(Integer.toHexString(n));
                    }
                }
            }
        });
        dialog.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static Glyph showDialog(String string, Glyph glyph) {
        if (dialog == null) {
            GlyphChooser.buildDialog();
        }
        dialog.setTitle(string);
        if (glyph == null) {
            glyph = defaultGlyph;
        }
        Font font = glyph.getFont();
        String string2 = GlyphChooser.bindName(font.getFontName());
        fontList.setSelectedItem(string2);
        String string3 = "" + font.getSize();
        fontSize.setSelectedItem(string3);
        char c = glyph.getChar();
        char c2 = (char)(c / 255 * 255);
        glyphPanel.setRange(c2);
        glyphPanel.setSelected(c % 255);
        preview.setGlyph(glyph);
        range.setText("" + Integer.toHexString(0xFFFF & c2));
        dialog.setVisible(true);
        return retVal;
    }

    private static String bindName(String string) {
        if (fontMap.get(string) == null) {
            string = fontNames[0];
        }
        return string;
    }

    private static void onFontChange() {
        try {
            String string = (String)fontList.getSelectedItem();
            int n = Integer.parseInt((String)fontSize.getSelectedItem());
            Font font = (Font)fontMap.get(string);
            font = GlyphChooser.newFont(string, n + 1);
            font = GlyphChooser.newFont(string, n);
            glyphPanel.setFont(font);
            Glyph glyph = preview.getGlyph();
            if (glyph != null) {
                preview.setGlyph(new Glyph(font, glyph.getChar()));
            } else {
                preview.setGlyph(new Glyph(font, '0'));
            }
            preview.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, ERROR_INVALID_FONT_SIZE);
            fontSize.requestFocus();
        }
    }

    private static Font newFont(String string, int n) {
        Font font = (Font)fontMap.get(string);
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.FAMILY, font.getFamily());
        hashtable.put(TextAttribute.SIZE, new Float(n));
        Font font2 = new Font(hashtable);
        return font2;
    }

    static {
        defaultFont = new Font("Times New Roman", 0, 12);
        defaultGlyph = new Glyph(defaultFont, '\u2200');
    }

    static class UnicodeRange {
        String desc;
        char cStart;

        public UnicodeRange(String string, char c) {
            this.desc = string;
            this.cStart = c;
        }

        public String toString() {
            return this.desc;
        }
    }
}

