### R code from vignette source 'GOSemSim.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(width=60)


###################################################
### code chunk number 2: preliminaries
###################################################
library(GOSemSim)
library(org.Hs.eg.db)
library(GO.db)


###################################################
### code chunk number 3: Params
###################################################
params <- new("Params", ontology="MF", organism="human", method="Wang")


###################################################
### code chunk number 4: GOSet
###################################################
go1 <- c("GO:0004022", "GO:0004024", "GO:0004023")
go2 <- c("GO:0009055", "GO:0020037")
gos <- new("GOSet", GOSet1=go1, GOSet2=go2)


###################################################
### code chunk number 5: GeneSet
###################################################
gs1 <- c("835", "5261","241", "994", "514", "533")
gs2 <- c("578","582", "400", "409", "411")
gs <- new("GeneSet", GeneSet1=gs1, GeneSet2=gs2)


###################################################
### code chunk number 6: GeneClusterSet
###################################################
x <- org.Hs.egGO
hsEG <- mappedkeys(x)
set.seed <- 123
clusters <- list(a=sample(hsEG, 20), b=sample(hsEG, 20), c=sample(hsEG, 20))
geneClusters <- new("GeneClusterSet", GeneClusters=clusters)


###################################################
### code chunk number 7: sim
###################################################
sim(gos,params)
setCombineMethod(params)<-"rcmax.avg"
sim(gos,params)
sim(gs, params)
sim(geneClusters, params)


###################################################
### code chunk number 8: old function call
###################################################
goSim("GO:0004022", "GO:0005515", ont="MF", measure="Wang")
go1 = c("GO:0004022","GO:0004024","GO:0004174")
go2 = c("GO:0009055","GO:0005515")
mgoSim(go1, go2, ont="MF", measure="Wang", combine="rcmax.avg")
geneSim("241", "251", ont="MF", organism="human", measure="Wang", combine="rcmax.avg")

mgeneSim(genes=c("835", "5261","241", "994"), ont="MF", organism="human", measure="Wang")

clusterSim(gs1, gs2, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")
mclusterSim(clusters, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")


###################################################
### code chunk number 9: GOSemSim.Rnw:197-198
###################################################
sessionInfo()


