### R code from vignette source 'DiffBind.Rnw'

###################################################
### code chunk number 1: DiffBind.Rnw:94-97
###################################################
tmp =  tempfile(as.character(Sys.getpid()))
pdf(tmp)
savewd = getwd()


###################################################
### code chunk number 2: DiffBind.Rnw:100-102
###################################################
library(DiffBind)
setwd(system.file("extra", package="DiffBind"))


###################################################
### code chunk number 3: DiffBind.Rnw:107-112 (eval = FALSE)
###################################################
## tamoxifen = dba(sampleSheet="tamoxifen.csv")
## tamoxifen = dba.count(tamoxifen)
## tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)
## tamoxifen = dba.analyze(tamoxifen)
## tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 4: DiffBind.Rnw:144-145
###################################################
tamoxifen = dba(sampleSheet="tamoxifen.csv")


###################################################
### code chunk number 5: DiffBind.Rnw:150-151
###################################################
tamoxifen


###################################################
### code chunk number 6: DiffBind.Rnw:172-173 (eval = FALSE)
###################################################
## plot(tamoxifen)


###################################################
### code chunk number 7: DiffBind.Rnw:189-190 (eval = FALSE)
###################################################
## tamoxifen = dba.count(tamoxifen, minOverlap=3) 


###################################################
### code chunk number 8: DiffBind.Rnw:193-194
###################################################
data(tamoxifen_counts)


###################################################
### code chunk number 9: DiffBind.Rnw:203-204
###################################################
tamoxifen = dba.contrast(tamoxifen, categories=DBA_CONDITION)


###################################################
### code chunk number 10: DiffBind.Rnw:224-225
###################################################
tamoxifen = dba.analyze(tamoxifen) 


###################################################
### code chunk number 11: DiffBind.Rnw:231-232
###################################################
tamoxifen    


###################################################
### code chunk number 12: DiffBind.Rnw:259-260
###################################################
tamoxifen.DB = dba.report(tamoxifen)


###################################################
### code chunk number 13: DiffBind.Rnw:265-266
###################################################
tamoxifen.DB


###################################################
### code chunk number 14: DiffBind.Rnw:303-304
###################################################
dba.plotMA(tamoxifen)


###################################################
### code chunk number 15: DiffBind.Rnw:323-324
###################################################
dba.plotPCA(tamoxifen, contrast=1, th=1)


###################################################
### code chunk number 16: DiffBind.Rnw:343-344
###################################################
dba.plotPCA(tamoxifen, contrast=1,th=.1)


###################################################
### code chunk number 17: DiffBind.Rnw:359-361
###################################################
sum(tamoxifen.DB$Fold<0)
sum(tamoxifen.DB$Fold>0)


###################################################
### code chunk number 18: DiffBind.Rnw:366-367
###################################################
pvals = dba.plotBox(tamoxifen)


###################################################
### code chunk number 19: DiffBind.Rnw:381-382
###################################################
pvals


###################################################
### code chunk number 20: DiffBind.Rnw:398-399
###################################################
corvals = dba.plotHeatmap(tamoxifen,contrast=1)


###################################################
### code chunk number 21: DiffBind.Rnw:404-405
###################################################
corvals = dba.plotHeatmap(tamoxifen, contrast=1, correlations=FALSE)


###################################################
### code chunk number 22: DiffBind.Rnw:423-424
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 23: DiffBind.Rnw:431-433
###################################################
olap.rate = dba.overlap(tamoxifen,mode=DBA_OLAP_RATE)
olap.rate


###################################################
### code chunk number 24: DiffBind.Rnw:441-442
###################################################
plot(olap.rate,type='b') 


###################################################
### code chunk number 25: DiffBind.Rnw:460-461
###################################################
names(tamoxifen$masks)


###################################################
### code chunk number 26: DiffBind.Rnw:470-471
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$MCF7,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 27: DiffBind.Rnw:478-479
###################################################
dba.plotVenn(tamoxifen,tamoxifen$masks$MCF7)


###################################################
### code chunk number 28: DiffBind.Rnw:492-495
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$MCF7,sampID="MCF7+")
tamoxifen = dba(tamoxifen,!(!tamoxifen$masks$Consensus&tamoxifen$masks$MCF7))
tamoxifen


###################################################
### code chunk number 29: DiffBind.Rnw:516-517
###################################################
data(tamoxifen_peaks)


###################################################
### code chunk number 30: DiffBind.Rnw:522-524
###################################################
dba.overlap(tamoxifen,tamoxifen$masks$Resistant,mode=DBA_OLAP_RATE)
dba.overlap(tamoxifen,tamoxifen$masks$Responsive,mode=DBA_OLAP_RATE)


###################################################
### code chunk number 31: DiffBind.Rnw:532-537
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Resistant,
                        sampID="Resistant",minOverlap=2)
tamoxifen = dba.peakset(tamoxifen,tamoxifen$mask$Responsive, 
                        sampID="Responsive",minOverlap=3)
dba.plotVenn(tamoxifen,tamoxifen$masks$Consensus)


###################################################
### code chunk number 32: DiffBind.Rnw:549-550
###################################################
tamoxifen.OL = dba.overlap(tamoxifen, tamoxifen$masks$Consensus)


###################################################
### code chunk number 33: DiffBind.Rnw:555-557
###################################################
tamoxifen.OL$onlyA
tamoxifen.OL$onlyB


###################################################
### code chunk number 34: DiffBind.Rnw:615-620
###################################################
tamoxifen = dba.peakset(tamoxifen,tamoxifen$masks$Consensus, 
                        minOverlap=1,sampID="OL Consensus")
tamoxifen = dba.peakset(tamoxifen,!tamoxifen$masks$Consensus,
                        minOverlap=3,sampID="Consensus_3") 
dba.plotVenn(tamoxifen,14:15)


###################################################
### code chunk number 35: DiffBind.Rnw:635-636
###################################################
data(tamoxifen_analysis)


###################################################
### code chunk number 36: DiffBind.Rnw:641-642
###################################################
tamoxifen.rep = dba.report(tamoxifen,bCalled=T,th=1)


###################################################
### code chunk number 37: DiffBind.Rnw:647-653
###################################################
onlyResistant = tamoxifen.rep$Called1>=2 & tamoxifen.rep$Called2<3
sum(onlyResistant )
onlyResponsive = tamoxifen.rep$Called2>=3 & tamoxifen.rep$Called1<2
sum(onlyResponsive)
bothGroups = tamoxifen.rep$Called1>=2 & tamoxifen.rep$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 38: DiffBind.Rnw:664-671
###################################################
tamoxifen.DB = dba.report(tamoxifen,bCalled=T,th=.1)
onlyResistant = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2<3
sum(onlyResistant)
onlyResponsive = tamoxifen.DB$Called2>=3 & tamoxifen.DB$Called1<2
sum(onlyResponsive)
bothGroups = tamoxifen.DB$Called1>=2 & tamoxifen.DB$Called2>=3
sum(bothGroups)


###################################################
### code chunk number 39: setup
###################################################
sessionInfo()


###################################################
### code chunk number 40: DiffBind.Rnw:743-746
###################################################
dev.off()
unlink(tmp)
setwd(savewd)


