###################################################
### chunk number 1: lkd1-1
###################################################
#line 67 "nov09rv.Rnw"
library(ind1KG)
library(Rsamtools)


###################################################
### chunk number 2: workaround
###################################################
#line 71 "nov09rv.Rnw"
readPileup <- selectMethod("readPileup", "connection")


###################################################
### chunk number 3: lkd1-2
###################################################
#line 74 "nov09rv.Rnw"
pup17 <- gzfile(system.file("pileups/n240_17.pup.gz", package="ind1KG"))
c17p.i <- readPileup(pup17, variant="indel")
levels(seqnames(c17p.i))
seqlevels(c17p.i) = gsub("17", "chr17", seqlevels(c17p.i))
c17p.i


###################################################
### chunk number 4: li
###################################################
#line 83 "nov09rv.Rnw"
library(SNPlocs.Hsapiens.dbSNP.20080617)
c6 <- getSNPlocs("chr6")
head(c6, 5)


###################################################
### chunk number 5: getg
###################################################
#line 108 "nov09rv.Rnw"
library(org.Hs.eg.db)
egid <- get("CDRT4", revmap(org.Hs.egSYMBOL))
kgid <- get(egid, org.Hs.egUCSCKG)
library(GenomicFeatures)
if (!exists("txdb")) {
 if (file.exists("hg18.txdb.sqlite")) txdb = loadFeatures("hg18.txdb.sqlite") else {
    txdb <- makeTranscriptDbFromUCSC(genome="hg18",
                           tablename="knownGene")
    saveFeatures(txdb, file="hg18.txdb.sqlite")  # for later use!
    }
}
txloc <- transcripts(txdb)
cdrt4txloc <- txloc[elementMetadata(txloc)$tx_name %in% kgid]
subsetByOverlaps(c17p.i, cdrt4txloc)


###################################################
### chunk number 6: lkm
###################################################
#line 125 "nov09rv.Rnw"
cdrt4txid <- as.character(elementMetadata(cdrt4txloc)$tx_id)
cdrt4exloc <- exonsBy(txdb)[cdrt4txid]
subsetByOverlaps(c17p.i, cdrt4exloc)


###################################################
### chunk number 7: lkd
###################################################
#line 152 "nov09rv.Rnw"
library(ind1KG)
library(chopsticks)
data(yri240_6)
yri240_6$hm
head(yri240_6$supp, 10)


###################################################
### chunk number 8: lklu
###################################################
#line 170 "nov09rv.Rnw"
library(lumiHumanIDMapping)
con <- lumiHumanIDMapping_dbconn()
dbListTables(con)
dbGetQuery(con, "select * from HumanWG6_V1 limit 5")


###################################################
### chunk number 9: ll
###################################################
#line 200 "nov09rv.Rnw"
sessionInfo()


